/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: ImportXmlStreamTasks.java 1493 2010-09-24 09:51:40Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.2.0/vradi-services/src/main/java/com/jurismarches/vradi/services/tasks/ImportXmlStreamTasks.java $
 * %%
 * Copyright (C) 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services.tasks;

import java.util.TimerTask;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.BindingManager;

/**
 * This task run at specified stream import time to import new stream.
 * 
 * @author chatellier
 * @version $Revision: 1493 $
 * 
 * Last update : $Date: 2010-09-24 11:51:40 +0200 (ven., 24 sept. 2010) $
 * By : $Author: chatellier $
 */
public class ImportXmlStreamTasks extends TimerTask {

    private static final Log log = LogFactory.getLog(ImportXmlStreamTasks.class);

    protected WikittyProxy wikittyProxy;

    protected BindingManager bindingManager;

    /** Il faut l'id du flux et non le flux (wikitty obselete). */
    protected String xmlStreamId;

    public ImportXmlStreamTasks(WikittyProxy wikittyProxy, BindingManager bindingManager, String xmlStreamId) {
        this.wikittyProxy = wikittyProxy;
        this.bindingManager = bindingManager;
        this.xmlStreamId = xmlStreamId;
    }

    /*
     * @see java.util.TimerTask#run()
     */
    @Override
    public void run() {

        try {
            XmlStream xmlStream = wikittyProxy.restore(XmlStream.class, xmlStreamId);
            if (log.isInfoEnabled()) {
                log.info("Starting xml stream import on : " + xmlStream.getName() + "...");
            }
            XmlStreamImportResult importResult = bindingManager.importFormsFromXmlStream(xmlStream);
            if (log.isInfoEnabled()) {
                log.info("Xml stream " + xmlStream.getName() + " imported : " + importResult.getCreatedFormCount() + " new forms.");
            }
        } catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import forms from stream " + xmlStreamId, ex);
            }
        }
    }
}
