/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiServiceAction {
    private static final Log log = LogFactory.getLog(VradiServiceAction.class);

    public void help() {
        System.out.println("Usage: vradi-services [-h]");
        System.out.println("Options (set with --option <key> <value>) :");
        for (VradiServiceConfiguration.Option option : VradiServiceConfiguration.Option.values()) {
            System.out.println("\t" + option.key + "(" + option.defaultValue + ") : " + option.description);
        }
        System.out.println("Actions:");
        for (Enum enum_ : VradiServiceConfiguration.ActionDefinition.values()) {
            System.out.println("\t" + Arrays.toString(((VradiServiceConfiguration.ActionDefinition)enum_).getAliases()) + "(" + ((VradiServiceConfiguration.ActionDefinition)enum_).getAction() + ") : " + ((VradiServiceConfiguration.ActionDefinition)enum_).getDescription());
        }
        System.exit(0);
    }

    public static void reIndexSolr() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting reIndex solr");
        }
        long startingTime = System.nanoTime();
        ServiceFactory.getWikittyProxy().syncEngin();
        if (log.isInfoEnabled()) {
            log.info((Object)("ReIndex solr is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        }
        System.exit(0);
    }

    public static void deleteObseleteThesaurus() {
        log.info((Object)"Starting deleting obselete thesaurus");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List thesauruses = proxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
        for (Thesaurus thesaurus : thesauruses) {
            String parentId = thesaurus.getParent();
            if (parentId == null) {
                proxy.delete(thesaurus.getWikittyId());
                log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parentId, deleting this"));
                continue;
            }
            Thesaurus parent = (Thesaurus)proxy.restore(Thesaurus.class, parentId);
            if (parent != null) continue;
            proxy.delete(thesaurus.getWikittyId());
            log.info((Object)("Found thesaurus '" + thesaurus.getName() + "' has no parent with id '" + parentId + ", deleting this"));
        }
        log.info((Object)("Deleting obselete thesaurus is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void reinitStatus() {
        log.info((Object)"Starting reinit status");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Status").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List statuses = proxy.findAllByCriteria(Status.class, criteria).getAll();
        ArrayList<String> statusesIds = new ArrayList<String>();
        for (Status status : statuses) {
            statusesIds.add(status.getWikittyId());
            log.info((Object)("Deleting status " + status.getName()));
        }
        proxy.delete(statusesIds);
        try {
            ServiceFactory.getVradiStorageService().createDefaultStatuses();
        }
        catch (VradiException eee) {
            log.error((Object)eee);
        }
        log.info((Object)("reinit status is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void forceAllOldUserEnable() {
        User user;
        log.info((Object)"Starting forcing all user enabled");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "User").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List users = proxy.findAllByCriteria(User.class, criteria).getAll();
        Iterator i$ = users.iterator();
        while (i$.hasNext() && (user = (User)i$.next()) != null) {
            Object field = user.getField("User", "enable");
            if (field != null) continue;
            log.info((Object)("Found user '" + user.getName() + "' with no enable"));
            user.setField("User", "enable", true);
            proxy.store((BusinessEntity)user);
        }
        log.info((Object)("Forcing all user enabled is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }

    public static void deleteObseleteUsers() {
        User user;
        log.info((Object)"Starting obselete user deletion");
        long startingTime = System.nanoTime();
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "User").criteria();
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        List users = proxy.findAllByCriteria(User.class, criteria).getAll();
        Iterator i$ = users.iterator();
        while (i$.hasNext() && (user = (User)i$.next()) != null) {
            String clientId = user.getClient();
            if (clientId == null) {
                log.info((Object)("Deleting user " + user.getName() + " with no client attached"));
                proxy.delete(user.getWikittyId());
                continue;
            }
            Client client = (Client)proxy.restore(Client.class, clientId);
            if (client != null) continue;
            log.info((Object)("Deleting user " + user.getName() + " with no client attached"));
            proxy.delete(user.getWikittyId());
        }
        log.info((Object)("Forcing all user enabled is finished in " + StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
        System.exit(0);
    }
}

