/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiServiceAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

public class Configuration
extends ApplicationConfig {
    private static final Log log = LogFactory.getLog(Configuration.class);
    protected static Configuration instance = null;

    protected Configuration() {
        for (Option o : Option.values()) {
            if (o.defaultValue == null) continue;
            this.setDefaultOption(o.key, o.defaultValue);
        }
    }

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            try {
                instance = new Configuration();
                instance = Configuration.loadOptionConfiguration(instance);
                instance.setSystemDefaultProps();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"", (Throwable)e);
                }
                throw new UnhandledException((Throwable)e);
            }
        }
        return instance;
    }

    protected static Configuration loadOptionConfiguration(Configuration configuration) throws ArgumentsParserException, IOException {
        String environment = System.getProperty("vradi.environment");
        if (environment == null || "prod".equals(environment)) {
            configuration.parse(new String[0]);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Using environment : " + environment));
            }
            configuration = Configuration.loadOptionConfigurationTest(configuration);
        }
        return configuration;
    }

    protected static Configuration loadOptionConfigurationTest(Configuration configuration) throws IOException {
        InputStream input = Configuration.class.getResourceAsStream("/vradi-services.properties");
        Properties options = new Properties();
        options.load(input);
        configuration.setOptions(options);
        configuration.setOption("vradi.data.dir", "target" + File.separator + "vradi");
        configuration.setWikittyListenEvents(false);
        configuration.setWikittyPropagateEvents(false);
        configuration.setWikittyJgroupsChannelName("");
        if (log.isInfoEnabled()) {
            log.info((Object)("Using options : " + configuration.getFlatOptions()));
        }
        return configuration;
    }

    public void initActions() {
        for (VradiServiceAction.ActionDefinition a : VradiServiceAction.ActionDefinition.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
    }

    protected void addActionAlias(String action, String ... aliases) {
        for (String alias : aliases) {
            super.addActionAlias(alias, action);
        }
    }

    @Deprecated
    public File getOptionAsFile2(String key) {
        String optionAsString = this.getOption(key);
        if (optionAsString != null) {
            File optionAsFile = new File(optionAsString);
            return optionAsFile.getAbsoluteFile();
        }
        return null;
    }

    public String getApplicationVersion() {
        return this.getOption(Option.APPLICATION_VERSION.key);
    }

    public String getServiceVersion() {
        return this.getOption(Option.SERVICE_VERSION.key);
    }

    public void setServiceVersion(String version) {
        this.setOption(Option.SERVICE_VERSION.key, version);
    }

    public String getDataDir() {
        String option = this.getOption(Option.DATA_DIR.key);
        return option;
    }

    public File getDataDirAsFile() {
        File option = this.getOptionAsFile(Option.DATA_DIR.key);
        return option;
    }

    @Deprecated
    public File getCommonsPropertiesFile() {
        return this.getOptionAsFile("vradi.data.dir", ".vradi-properties");
    }

    public File getAttachmentsDir() {
        return this.getOptionAsFile("vradi.data.dir", "attachments");
    }

    public File getEmbeddedFilesDir() {
        return this.getOptionAsFile("vradi.data.dir", "embeddedFiles");
    }

    public File getQueryHistoryDir() {
        return this.getOptionAsFile("vradi.data.dir", "queryHistory");
    }

    public File getTemplatesDir() {
        return this.getOptionAsFile("vradi.data.dir", "templates");
    }

    public File getPdfDir() {
        return this.getOptionAsFile("vradi.data.dir", "pdf");
    }

    public File getWebHarvestPreviewDir() {
        return this.getOptionAsFile("vradi.data.dir", "WebHarvestPreview");
    }

    public File getWebHarvestScriptDir() {
        return this.getOptionAsFile("vradi.data.dir", "WebHarvestScript");
    }

    public String getOpenOfficeExecDir() {
        return this.getOption("oOo.exec.folder");
    }

    public String getSmtpHost() {
        return this.getOption("vradi.smtp.host");
    }

    public int getSmtpPort() {
        return this.getOptionAsInt("vradi.smtp.port");
    }

    public String getImapHost() {
        return this.getOption("vradi.imap.host");
    }

    public int getImapPort() {
        return this.getOptionAsInt("vradi.imap.port");
    }

    public String getMailUser() {
        return this.getOption("vradi.mail.user");
    }

    public String getMailFrom() {
        return this.getOption("vradi.mail.from");
    }

    public String getMailFromName() {
        return this.getOption("vradi.mail.fromname");
    }

    public String getMailPassword() {
        return this.getOption("vradi.mail.password");
    }

    public String getOfferMailSubject() {
        String result = this.getOption("vradi.mail.offer.subject");
        return result;
    }

    public boolean isMailDebug() {
        return this.getOptionAsBoolean("vradi.mail.debug");
    }

    public String getSessionDefaultParagraph() {
        return this.getOption("vradi.session.defaultParagraph");
    }

    public boolean skipMigration() {
        return this.getOptionAsBoolean("vradi.migration.skip");
    }

    public void setWikittyJgroupsChannelName(String channelName) {
        this.setOption(Option.WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION.key, channelName);
    }

    public void setWikittyPropagateEvents(boolean b) {
        this.setOption(Option.WIKITTY_EVENT_PROPAGATE_OPTION.key, String.valueOf(b));
    }

    public void setWikittyListenEvents(boolean b) {
        this.setOption(Option.WIKITTY_CACHE_LISTENEVENTS_OPTION.key, String.valueOf(b));
    }

    public void setWikittyCachePolicy(boolean b) {
        this.setOption(Option.WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES.key, String.valueOf(b));
    }

    protected File getOptionAsFile(String parent, String child) {
        String parentDir = this.getOption(parent);
        File option = new File(parentDir, child);
        return option;
    }

    protected void setSystemDefaultProps() {
        String[] datadirs;
        for (String datadir : datadirs = new String[]{"solr.data.dir", "vradi.objectStore.dir"}) {
            String value = System.getProperty(datadir, null);
            if (value != null) continue;
            value = this.getOption(datadir);
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting system property " + datadir + " : " + value));
            }
            System.setProperty(datadir, value);
            this.env.put(datadir, value);
        }
    }

    public File getTempDir() {
        String tempDir = this.getOption(Option.TEMP_DIR.key);
        return new File(tempDir);
    }

    public static enum Option {
        CONFIG_FILE("config.file", I18n._((String)"vradi.service.config.configFileName.description"), "vradi-services.properties", String.class, true, true),
        APPLICATION_VERSION("application.version", I18n._((String)"vradi.service.config.application.version.description"), null, String.class, false, false),
        SERVICE_VERSION("vradi.service.version", I18n._((String)"vradi.service.config.version.description"), null, String.class, false, false),
        DATA_DIR("vradi.data.dir", I18n._((String)"vradi.service.config.data.dir.description"), null, Boolean.class, false, false),
        TEMP_DIR("vradi.temp.dir", I18n._((String)"vradi.service.config.temp.dir.description"), null, Boolean.class, false, false),
        WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION("wikitty.service.event.jgroupschannelname", I18n._((String)"vradi.service.config.wikitty.jgroupschannelname.description"), "wikitty-vradi", Boolean.class, false, false),
        WIKITTY_EVENT_PROPAGATE_OPTION("wikitty.service.event.propagateEvent", I18n._((String)"vradi.service.config.wikitty.propagate.description"), "true", Boolean.class, false, false),
        WIKITTY_CACHE_LISTENEVENTS_OPTION("wikitty.service.cache.listenevents", I18n._((String)"vradi.service.config.listenevents.description"), "true", Boolean.class, false, false),
        WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES("wikitty.service.cache.allwaysRestoreCopies", I18n._((String)"vradi.service.config.cacheusecopies.description"), "true", Boolean.class, false, false);

        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean isTransient;
        public final boolean isFinal;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }
    }
}

