/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;

public class VradiSendingDTO {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected Sending sending;
    protected VradiClientDTO clientDTO;
    protected List<VradiFormDTO> formDTOs = new ArrayList<VradiFormDTO>();

    public VradiSendingDTO(Sending wikitty) {
        this.sending = wikitty;
        this.setClientDTO(new VradiClientDTO());
        try {
            this.getClientDTO().fromWikitty(ServiceHelper.getVradiStorageService().getClient(wikitty.getClient()));
            this.sending.setClient(this.getClientDTO().getWikittyId());
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
        }
        try {
            this.sending.clearForm();
            this.setFormDTOs(ServiceHelper.getVradiStorageService().getForms(new ArrayList<String>(wikitty.getForm())));
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
        }
        this.sending.setParagraph(wikitty.getParagraph());
        this.sending.setReceptionProof(wikitty.getReceptionProof());
        this.sending.setStatus(wikitty.getStatus());
        this.sending.setReceptionDate(wikitty.getReceptionDate());
        this.sending.setSentDate(wikitty.getSentDate());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public VradiClientDTO getClientDTO() {
        return this.clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        this.clientDTO = clientDTO;
    }

    public List<VradiFormDTO> getFormDTOs() {
        return this.formDTOs;
    }

    public void setFormDTOs(List<Form> forms) {
        if (forms != null) {
            this.formDTOs = new ArrayList<VradiFormDTO>();
            for (Form form : forms) {
                this.sending.addForm(form.getWikittyId());
                VradiFormDTO formDTO = new VradiFormDTO();
                formDTO.fromWikitty(form);
                this.formDTOs.add(formDTO);
            }
        }
    }

    public void removeFormDTO(VradiFormDTO form) {
        if (form != null) {
            this.formDTOs.remove(form);
            this.sending.removeForm(form.getWikittyId());
        }
    }

    public void setSentDate(Date value) {
        Date oldValue = this.getSentDate();
        this.sending.setSentDate(value);
        this.propertyChange.firePropertyChange("sentDate", oldValue, value);
    }

    public Date getSentDate() {
        return this.sending.getSentDate();
    }

    public void setReceptionDate(Date value) {
        Date oldValue = this.getReceptionDate();
        this.sending.setReceptionDate(value);
        this.propertyChange.firePropertyChange("receptionDate", oldValue, value);
    }

    public Date getReceptionDate() {
        return this.sending.getReceptionDate();
    }

    public void setParagraph(String value) {
        String oldValue = this.getParagraph();
        this.sending.setParagraph(value);
        this.propertyChange.firePropertyChange("paragraph", oldValue, value);
    }

    public String getParagraph() {
        return this.sending.getParagraph();
    }

    public void setReceptionProof(boolean value) {
        Boolean oldValue = this.getReceptionProof();
        this.sending.setReceptionProof(value);
        this.propertyChange.firePropertyChange("receptionProof", oldValue, (Object)value);
    }

    public boolean getReceptionProof() {
        return this.sending.getReceptionProof();
    }

    public void setStatus(int value) {
        Integer oldValue = this.getStatus();
        this.sending.setStatus(value);
        this.propertyChange.firePropertyChange("status", oldValue, (Object)value);
    }

    public int getStatus() {
        return this.sending.getStatus();
    }

    public Sending getSending() {
        return this.sending;
    }
}

