/*
 * *##%
 * Vradi :: Entities
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.entities;

import java.util.LinkedHashMap;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

/**
 * Thesaurus extension for {@link TreeNode}.
 * 
 * Changes in this extension :
 * <ul>
 *  <li>2.0 : add order field (numeric)
 *  <li>1.0 : intial version
 * </ul>
 * 
 * @author chatellier
 * @version $Revision: 756 $
 * 
 * Last update : $Date: 2010-04-26 11:02:19 +0200 (lun., 26 avril 2010) $
 * By : $Author: chatellier $
 */
public class Thesaurus {

    public static final String EXT_THESAURUS = "Thesaurus";
    public static final String VERSION_THESAURUS = "2.0";
    public static final String TAGS_FIELD = "tags";
    public static final String FQ_TAGS_FIELD = EXT_THESAURUS + ".tags";
    public static final String ORDER_FIELD = "order";
    public static final String FQ_ORDER_FIELD = EXT_THESAURUS + ".order";
    public static final String COMMENT_FIELD = "comment";
    public static final String FQ_COMMENT_FIELD = EXT_THESAURUS + ".comment";
    
    static final public WikittyExtension EXTENSION_THESAURUS = getExtension();

    public static final WikittyExtension getExtension() {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put(ORDER_FIELD, new FieldType(FieldType.TYPE.NUMERIC, 0, 1));
        fields.put(TAGS_FIELD, new FieldType(FieldType.TYPE.STRING, 0, FieldType.NOLIMIT));
        fields.put(COMMENT_FIELD, new FieldType(FieldType.TYPE.STRING, 0, 1));
        WikittyExtension thesaurusExtension = new WikittyExtension(EXT_THESAURUS, VERSION_THESAURUS,
                TreeNodeImpl.EXT_TREENODE, fields);
        return thesaurusExtension;
    }
}
