package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class FormImpl extends com.jurismarches.vradi.entities.InfogeneImpl implements Form, Infogene {

    private static final long serialVersionUID = -49743860L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionForm =
        new WikittyExtension(EXT_FORM, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date datePub unique",
				"Date datePeremption unique",
				"String thesaurus[0-*] unique",
				"Wikitty sending[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionForm);

        exts.addAll(InfogeneImpl.extensions);
        extensions = Collections.unmodifiableList(exts);
    }
 
	public FormImpl() {
		super();
	}

    public FormImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public FormImpl(Wikitty wi) {
		super(wi);
	}


    public void setDatePub(Date datePub) {
        getWikitty().setField(EXT_FORM, "datePub", datePub);
    }

    public Date getDatePub() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePub");
        return result;
    }


    public void setDatePeremption(Date datePeremption) {
        getWikitty().setField(EXT_FORM, "datePeremption", datePeremption);
    }

    public Date getDatePeremption() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePeremption");
        return result;
    }

    public Set<String> getThesaurus() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "thesaurus", String.class);
        return result;
    }

    public void addThesaurus(String element) {
        getWikitty().addToField(EXT_FORM, "thesaurus", element);
    }
    
    public void removeThesaurus(String element) {
        getWikitty().removeFromField(EXT_FORM, "thesaurus", element);
    }
    
    public void clearThesaurus() {
        getWikitty().clearField(EXT_FORM, "thesaurus");
    }

    public Set<String> getSending() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "sending", String.class);
        return result;
    }

    public void addSending(String element) {
        getWikitty().addToField(EXT_FORM, "sending", element);
    }
    
    public void removeSending(String element) {
        getWikitty().removeFromField(EXT_FORM, "sending", element);
    }
    
    public void clearSending() {
        getWikitty().clearField(EXT_FORM, "sending");
    }


    public void setId(String id) {
        getWikitty().setField(EXT_INFOGENE, "id", id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "id");
        return result;
    }


    public void setObjet(String objet) {
        getWikitty().setField(EXT_INFOGENE, "objet", objet);
    }

    public String getObjet() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "objet");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_INFOGENE, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_INFOGENE, "creationDate");
        return result;
    }


    public void setSourceURL(String sourceURL) {
        getWikitty().setField(EXT_INFOGENE, "sourceURL", sourceURL);
    }

    public String getSourceURL() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceURL");
        return result;
    }


    public void setSourceText(String sourceText) {
        getWikitty().setField(EXT_INFOGENE, "sourceText", sourceText);
    }

    public String getSourceText() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceText");
        return result;
    }


    public void setEntity(String entity) {
        getWikitty().setField(EXT_INFOGENE, "entity", entity);
    }

    public String getEntity() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "entity");
        return result;
    }


    public void setCountry(String country) {
        getWikitty().setField(EXT_INFOGENE, "country", country);
    }

    public String getCountry() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "country");
        return result;
    }


    public void setDepartment(String department) {
        getWikitty().setField(EXT_INFOGENE, "department", department);
    }

    public String getDepartment() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "department");
        return result;
    }


    public void setDescription(String description) {
        getWikitty().setField(EXT_INFOGENE, "description", description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "description");
        return result;
    }


    public void setStatus(String status) {
        getWikitty().setField(EXT_INFOGENE, "status", status);
    }

    public String getStatus() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "status");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //FormImpl
