/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.time.TemporalAccessConverter;

public class YearMonthConverter
extends TemporalAccessConverter<YearMonth> {
    private static final DateTimeFormatter _defaultFormatter = DateTimeFormatter.ofPattern("MM/yy");
    private static final DateTimeFormatter _shortFormat = DateTimeFormatter.ofPattern("MMyy");
    private static final DateTimeFormatter _mediumFormat = DateTimeFormatter.ofPattern("MM/yy");
    private static final DateTimeFormatter _longFormat = DateTimeFormatter.ofPattern("MMM, yyyy");
    private static final DateTimeFormatter _fullFormat = DateTimeFormatter.ofPattern("MMMMM, yyyy");

    public YearMonthConverter() {
        this.setDefaultDateTimeFormatter(_defaultFormatter);
    }

    @Override
    public synchronized YearMonth fromString(String string, ConverterContext context) {
        TemporalAccessor temporalAccessor = this.temporalFromString(string, context);
        if (temporalAccessor != null) {
            return YearMonth.from(temporalAccessor);
        }
        return null;
    }

    @Override
    protected DateTimeFormatter getFullDateTimeFormatter() {
        return _fullFormat;
    }

    @Override
    protected DateTimeFormatter getLongDateTimeFormatter() {
        return _longFormat;
    }

    @Override
    protected DateTimeFormatter getMediumDateTimeFormatter() {
        return _mediumFormat;
    }

    @Override
    protected DateTimeFormatter getShortDateTimeFormatter() {
        return _shortFormat;
    }
}

