/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.time;

import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public abstract class TemporalAccessConverter<T extends Temporal>
extends DefaultObjectConverter<T> {
    public static final String PROPERTY_DATE_TIME_FORMATTER = "DateTimeFormatter";
    private DateTimeFormatter _defaultFormatter = null;

    @Override
    public synchronized String toString(T value, ConverterContext context) {
        Object formatter;
        if (value == null) {
            return "";
        }
        Object object = formatter = context != null ? context.getProperties().get((Object)PROPERTY_DATE_TIME_FORMATTER) : null;
        if (formatter instanceof DateTimeFormatter) {
            return ((DateTimeFormatter)formatter).withLocale(Locale.getDefault()).format((TemporalAccessor)value);
        }
        return this.getDefaultDateTimeFormatter().withLocale(Locale.getDefault()).format((TemporalAccessor)value);
    }

    public synchronized TemporalAccessor temporalFromString(String string, ConverterContext context) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object formatter;
            Object object = formatter = context != null ? context.getProperties().get((Object)PROPERTY_DATE_TIME_FORMATTER) : null;
            if (formatter instanceof DateTimeFormatter) {
                return ((DateTimeFormatter)formatter).withLocale(Locale.getDefault()).parse(string);
            }
            return this.getDefaultDateTimeFormatter().withLocale(Locale.getDefault()).parse(string);
        }
        catch (Exception e1) {
            try {
                return this.getShortDateTimeFormatter().withLocale(Locale.getDefault()).parse(string);
            }
            catch (Exception e2) {
                try {
                    return this.getMediumDateTimeFormatter().withLocale(Locale.getDefault()).parse(string);
                }
                catch (Exception e3) {
                    try {
                        return this.getLongDateTimeFormatter().withLocale(Locale.getDefault()).parse(string);
                    }
                    catch (Exception e4) {
                        try {
                            return this.getFullDateTimeFormatter().withLocale(Locale.getDefault()).parse(string);
                        }
                        catch (Exception e5) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    protected abstract DateTimeFormatter getFullDateTimeFormatter();

    protected abstract DateTimeFormatter getLongDateTimeFormatter();

    protected abstract DateTimeFormatter getMediumDateTimeFormatter();

    protected abstract DateTimeFormatter getShortDateTimeFormatter();

    public DateTimeFormatter getDefaultDateTimeFormatter() {
        return this._defaultFormatter;
    }

    public void setDefaultDateTimeFormatter(DateTimeFormatter defaultFormat) {
        this._defaultFormatter = defaultFormat;
    }
}

