/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

class FontUtils {
    FontUtils() {
    }

    public static List<String> getSupportedFontStyles(String fontFamily, double size) {
        FontWeight[] values;
        ArrayList<String> styles = new ArrayList<String>();
        for (FontWeight value : values = FontWeight.values()) {
            Font font = Font.font((String)fontFamily, (FontWeight)value, (double)size);
            if (styles.contains(font.getStyle())) continue;
            styles.add(font.getStyle());
        }
        Font font = Font.font((String)fontFamily, (FontPosture)FontPosture.ITALIC, (double)size);
        if (!styles.contains(font.getStyle())) {
            styles.add(font.getStyle());
        }
        return styles;
    }

    public static Font createFont(String fontFamily, String fontStyle, double fontSize) {
        Font font = null;
        if (fontFamily == null && fontStyle == null) {
            font = Font.getDefault();
        }
        if (font == null && fontStyle == null) {
            font = Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        }
        if (font == null && fontFamily == null) {
            fontFamily = Font.getDefault().getFamily();
        }
        if (font == null) {
            FontWeight[] values;
            block0: for (FontWeight weight : values = FontWeight.values()) {
                for (FontPosture posture : FontPosture.values()) {
                    Font f = Font.font((String)fontFamily, (FontWeight)weight, (FontPosture)posture, (double)fontSize);
                    if (!f.getStyle().equals(fontStyle) || !f.getFamily().equals(fontFamily)) continue;
                    font = f;
                    break block0;
                }
            }
            if (font == null) {
                font = Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)fontSize);
            }
        }
        return font;
    }
}

