/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.text.NumberFormat;
import java.text.ParseException;
import javafx.scene.text.Font;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.javafx.FontUtils;

public class FontConverter
extends DefaultObjectConverter<Font> {
    private String _separator = ", ";
    private NumberFormat _numberFormat = null;

    public FontConverter() {
        this(", ");
    }

    public FontConverter(String separator) {
        this.setSeparator(separator);
    }

    public String getSeparator() {
        return this._separator;
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = NumberFormat.getNumberInstance();
            this._numberFormat.setMaximumFractionDigits(1);
            this._numberFormat.setMinimumFractionDigits(1);
            this._numberFormat.setMaximumIntegerDigits(3);
        }
        return this._numberFormat;
    }

    @Override
    public String toString(Font font, ConverterContext context) {
        if (font == null) {
            return null;
        }
        return font.getFamily() + this._separator + font.getStyle() + this._separator + this.getNumberFormat().format(font.getSize());
    }

    @Override
    public Font fromString(String string, ConverterContext context) {
        if (string != null && !string.trim().isEmpty()) {
            String fontFamily = null;
            String[] strings = string.split(this._separator);
            if (strings.length > 0) {
                fontFamily = strings[0].trim();
            }
            String fontStyle = null;
            if (strings.length > 1) {
                fontStyle = strings[1].trim();
            }
            double fontSize = Font.getDefault().getSize();
            if (strings.length > 2) {
                try {
                    fontSize = this.getNumberFormat().parse(strings[2].trim()).doubleValue();
                }
                catch (ParseException ignored) {
                    // empty catch block
                }
            }
            return FontUtils.createFont(fontFamily, fontStyle, fontSize);
        }
        return null;
    }
}

