/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SerDesPair
implements Serializable {
    private static final long serialVersionUID = -1291992612139840722L;
    private String name;
    private String description;
    private String fileId;
    private String serializerClassName;
    private String deserializerClassName;

    public SerDesPair() {
    }

    public SerDesPair(String name, String description, String fileId, String serializerClassName, String deserializerClassName) {
        this.name = name;
        this.description = description;
        this.fileId = fileId;
        this.serializerClassName = serializerClassName;
        this.deserializerClassName = deserializerClassName;
        this.checkNotNullAndEmpty(name, "name");
        this.checkNotNullAndEmpty(fileId, "fileId");
        this.checkNotNullAndEmpty(serializerClassName, "serializerClassName");
        this.checkNotNullAndEmpty(deserializerClassName, "deserializerClassName");
    }

    private void checkNotNullAndEmpty(String arg, String argName) {
        if (arg == null || arg.trim().isEmpty()) {
            throw new IllegalArgumentException(argName + " can not be null");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    public String getDeserializerClassName() {
        return this.deserializerClassName;
    }

    public String toString() {
        return "SerDesPair{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fileId='" + this.fileId + '\'' + ", serializerClassName='" + this.serializerClassName + '\'' + ", deserializerClassName='" + this.deserializerClassName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerDesPair that = (SerDesPair)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.fileId != null ? !this.fileId.equals(that.fileId) : that.fileId != null) {
            return false;
        }
        if (this.serializerClassName != null ? !this.serializerClassName.equals(that.serializerClassName) : that.serializerClassName != null) {
            return false;
        }
        return this.deserializerClassName != null ? this.deserializerClassName.equals(that.deserializerClassName) : that.deserializerClassName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.fileId != null ? this.fileId.hashCode() : 0);
        result = 31 * result + (this.serializerClassName != null ? this.serializerClassName.hashCode() : 0);
        result = 31 * result + (this.deserializerClassName != null ? this.deserializerClassName.hashCode() : 0);
        return result;
    }
}

