/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStates;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaVersion
implements Serializable {
    private static final long serialVersionUID = 1664618495690787804L;
    private String description;
    private String schemaText;
    private Byte initialState;
    private byte[] stateDetails;

    private SchemaVersion() {
        this(null, null, null);
    }

    public SchemaVersion(String schemaText, String description) {
        this(schemaText, description, null);
    }

    public SchemaVersion(String schemaText, String description, Byte initialState) {
        this(schemaText, description, initialState, null);
    }

    public SchemaVersion(String schemaText, String description, Byte initialState, byte[] stateDetails) {
        this.description = description;
        this.schemaText = schemaText;
        this.initialState = initialState != null ? initialState : SchemaVersionLifecycleStates.ENABLED.getId();
        this.stateDetails = stateDetails;
    }

    public void setState(Byte state) {
        this.initialState = state;
    }

    public void setStateDetails(byte[] abstractStateDetails) {
        this.stateDetails = abstractStateDetails;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSchemaText() {
        return this.schemaText;
    }

    public Byte getInitialState() {
        return this.initialState;
    }

    public byte[] getStateDetails() {
        return this.stateDetails;
    }

    public String toString() {
        return "SchemaVersion{description='" + this.description + '\'' + ", schemaText='" + this.schemaText + '\'' + ", initialState='" + this.initialState + '\'' + ", details=" + this.stateDetails + '}';
    }
}

