/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.UseDirectEqualsAndHashCode;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.map.LRUMap;
import java.util.AbstractSet;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUSet<ELEMENTTYPE>
extends AbstractSet<ELEMENTTYPE>
implements ICommonsOrderedSet<ELEMENTTYPE> {
    private final LRUCacheMap m_aMap;

    public LRUSet(@Nonnegative int n) {
        this.m_aMap = new LRUCacheMap(n);
    }

    public LRUSet(@Nonnegative LRUSet<ELEMENTTYPE> lRUSet) {
        this.m_aMap = new LRUCacheMap(lRUSet.m_aMap);
    }

    @Override
    public @NonNull LRUSet<ELEMENTTYPE> getClone() {
        return new LRUSet<ELEMENTTYPE>(this);
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @NonNull ELEMENTTYPE ELEMENTTYPE) {
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_aMap.getMaxSize();
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.contains(ELEMENTTYPE)) {
            return false;
        }
        this.m_aMap.put(ELEMENTTYPE, Boolean.TRUE);
        return true;
    }

    @Override
    public @NonNull Iterator<ELEMENTTYPE> iterator() {
        return this.m_aMap.keySet().iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LRUSet lRUSet = (LRUSet)object;
        return this.m_aMap.equals(lRUSet.m_aMap);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aMap).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator((Object)this).append("map", (Object)this.m_aMap).getToString();
    }

    @UseDirectEqualsAndHashCode
    private final class LRUCacheMap
    extends LRUMap<ELEMENTTYPE, Boolean> {
        LRUCacheMap(int n) {
            super(n);
        }

        LRUCacheMap(LRUCacheMap lRUCacheMap) {
            super(lRUCacheMap);
        }

        @Override
        protected void onRemoveEldestEntry(@Nonnegative int n,  @NonNull Map.Entry<ELEMENTTYPE, Boolean> entry) {
            LRUSet.this.onRemoveEldestEntry(n, entry.getKey());
        }
    }
}

