/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.AutocompletePrediction;
import com.google.maps.model.LatLng;

public class QueryAutocompleteRequest
extends PendingResultBase<AutocompletePrediction[], QueryAutocompleteRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/queryautocomplete/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    protected QueryAutocompleteRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("input")) {
            throw new IllegalArgumentException("Request must contain 'input'.");
        }
    }

    public QueryAutocompleteRequest input(String input) {
        return (QueryAutocompleteRequest)this.param("input", input);
    }

    public QueryAutocompleteRequest offset(int offset) {
        return (QueryAutocompleteRequest)this.param("offset", String.valueOf(offset));
    }

    public QueryAutocompleteRequest location(LatLng location) {
        return (QueryAutocompleteRequest)this.param("location", location);
    }

    public QueryAutocompleteRequest radius(int radius) {
        return (QueryAutocompleteRequest)this.param("radius", String.valueOf(radius));
    }

    public static class Response
    implements ApiResponse<AutocompletePrediction[]> {
        public String status;
        public AutocompletePrediction[] predictions;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public AutocompletePrediction[] getResult() {
            return this.predictions;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

