/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.maps.GeolocationApi;
import com.google.maps.PendingResult;
import com.google.maps.PhotoRequest;
import com.google.maps.errors.ApiException;
import com.google.maps.errors.UnknownErrorException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.DateTimeAdapter;
import com.google.maps.internal.DayOfWeekAdaptor;
import com.google.maps.internal.DistanceAdapter;
import com.google.maps.internal.DurationAdapter;
import com.google.maps.internal.EncodedPolylineInstanceCreator;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.FareAdapter;
import com.google.maps.internal.GeolocationResponseAdapter;
import com.google.maps.internal.InstantAdapter;
import com.google.maps.internal.LatLngAdapter;
import com.google.maps.internal.LocalTimeAdapter;
import com.google.maps.internal.PriceLevelAdaptor;
import com.google.maps.internal.SafeEnumAdapter;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.AddressType;
import com.google.maps.model.Distance;
import com.google.maps.model.Duration;
import com.google.maps.model.EncodedPolyline;
import com.google.maps.model.Fare;
import com.google.maps.model.LatLng;
import com.google.maps.model.LocationType;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.PhotoResult;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.PriceLevel;
import com.google.maps.model.TravelMode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaePendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T> {
    private final HTTPRequest request;
    private final URLFetchService client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private final Integer maxRetries;
    private final ExceptionsAllowedToRetry exceptionsAllowedToRetry;
    private long errorTimeOut;
    private int retryCounter = 0;
    private long cumulativeSleepTime = 0L;
    private Future<HTTPResponse> call;
    private static final Logger LOG = LoggerFactory.getLogger((String)GaePendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public GaePendingResult(HTTPRequest request, URLFetchService client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.maxRetries = maxRetries;
        this.exceptionsAllowedToRetry = exceptionsAllowedToRetry;
        this.call = client.fetchAsync(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        throw new RuntimeException("setCallback not implemented for Google App Engine");
    }

    @Override
    public T await() throws ApiException, IOException, InterruptedException {
        try {
            return this.parseResponse(this, this.call.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new UnknownErrorException("Unexpected exception from " + e.getMessage());
        }
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel(true);
    }

    private T parseResponse(GaePendingResult<T, R> request, HTTPResponse response) throws IOException, ApiException, InterruptedException {
        ApiResponse resp;
        if (this.shouldRetry(response)) {
            return super.retry();
        }
        byte[] bytes = response.getContent();
        String contentType = null;
        for (HTTPHeader header : response.getHeaders()) {
            if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
            contentType = header.getValue();
        }
        if (contentType != null && contentType.startsWith("image") && this.responseClass == PhotoRequest.Response.class && response.getResponseCode() == 200) {
            PhotoResult result = new PhotoResult();
            result.contentType = contentType;
            result.imageData = bytes;
            return (T)result;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new DateTimeAdapter()).registerTypeAdapter(Distance.class, (Object)new DistanceAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(Fare.class, (Object)new FareAdapter()).registerTypeAdapter(LatLng.class, (Object)new LatLngAdapter()).registerTypeAdapter(AddressComponentType.class, new SafeEnumAdapter<AddressComponentType>(AddressComponentType.UNKNOWN)).registerTypeAdapter(AddressType.class, new SafeEnumAdapter<AddressType>(AddressType.UNKNOWN)).registerTypeAdapter(TravelMode.class, new SafeEnumAdapter<TravelMode>(TravelMode.UNKNOWN)).registerTypeAdapter(LocationType.class, new SafeEnumAdapter<LocationType>(LocationType.UNKNOWN)).registerTypeAdapter(PlaceDetails.Review.AspectRating.RatingType.class, new SafeEnumAdapter<PlaceDetails.Review.AspectRating.RatingType>(PlaceDetails.Review.AspectRating.RatingType.UNKNOWN)).registerTypeAdapter(OpeningHours.Period.OpenClose.DayOfWeek.class, (Object)new DayOfWeekAdaptor()).registerTypeAdapter(PriceLevel.class, (Object)new PriceLevelAdaptor()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeAdapter()).registerTypeAdapter(GeolocationApi.Response.class, (Object)new GeolocationResponseAdapter()).registerTypeAdapter(EncodedPolyline.class, (Object)new EncodedPolylineInstanceCreator("")).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        try {
            resp = (ApiResponse)gson.fromJson(new String(bytes, "utf8"), this.responseClass);
        }
        catch (JsonSyntaxException e) {
            if (response.getResponseCode() > 399) {
                throw new IOException(String.format("Server Error: %d %s", response.getResponseCode(), new String(response.getContent(), Charset.defaultCharset())));
            }
            throw e;
        }
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (this.shouldRetry(e)) {
            return super.retry();
        }
        throw e;
    }

    private T retry() throws IOException, ApiException, InterruptedException {
        ++this.retryCounter;
        LOG.info("Retrying request. Retry #{}", (Object)this.retryCounter);
        this.call = this.client.fetchAsync(this.request);
        return this.await();
    }

    private boolean shouldRetry(HTTPResponse response) {
        return RETRY_ERROR_CODES.contains(response.getResponseCode()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }

    private boolean shouldRetry(ApiException exception) {
        return this.exceptionsAllowedToRetry.contains(exception.getClass()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }
}

