/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionResult;
import com.google.maps.internal.OkHttpPendingResult;
import com.google.maps.internal.RateLimitExecutorService;
import com.google.maps.internal.UrlSigner;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoApiContext {
    private static final String VERSION = "0.1.1-SNAPSHOT";
    private static final String DEFAULT_HOST = "https://maps.googleapis.com";
    private static final String USER_AGENT = "GoogleGeoApiClientJava/0.1.1-SNAPSHOT";
    private static final int DEFAULT_QUERIES_PER_SECOND = 10;
    private static final int DEFAULT_BACKOFF_TIMEOUT_MILLIS = 60000;
    private String host = "https://maps.googleapis.com";
    private String apiKey;
    private String clientId;
    private UrlSigner urlSigner;
    private OkHttpClient client = new OkHttpClient();
    private static Logger log = Logger.getLogger(GeoApiContext.class.getName());
    private long errorTimeout = 60000L;

    public GeoApiContext() {
        this.setQueryRateLimit(10);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(Class<R> clazz, String path, Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            query.append('&').append(param.getKey()).append("=");
            try {
                query.append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new ExceptionResult(e);
            }
        }
        return this.getWithPath(clazz, FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES, path, query.toString());
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(Class<R> clazz, String path, String ... params) {
        return this.get(clazz, FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES, path, params);
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, String path, String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Params must be matching key/value pairs.");
        }
        StringBuilder query = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            query.append('&').append(params[i]).append('=');
            ++i;
            try {
                query.append(URLEncoder.encode(params[i], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                return new ExceptionResult(e);
            }
        }
        return this.getWithPath(clazz, fieldNamingPolicy, path, query.toString());
    }

    private <T, R extends ApiResponse<T>> PendingResult<T> getWithPath(Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, String path, String encodedPath) {
        this.checkContext();
        if (!encodedPath.startsWith("&")) {
            throw new IllegalArgumentException("encodedPath must start with &");
        }
        StringBuilder url = new StringBuilder(path);
        if (this.clientId != null) {
            url.append("?client=").append(this.clientId);
        } else {
            url.append("?key=").append(this.apiKey);
        }
        url.append(encodedPath);
        if (this.clientId != null) {
            try {
                String signature = this.urlSigner.getSignature(url.toString());
                url.append("&signature=").append(signature);
            }
            catch (Exception e) {
                return new ExceptionResult(e);
            }
        }
        String string = String.valueOf(String.valueOf(this.host));
        String string2 = String.valueOf(String.valueOf(url));
        Request req = new Request.Builder().get().header("User-Agent", USER_AGENT).url(new StringBuilder(0 + string.length() + string2.length()).append(string).append(string2).toString()).build();
        String string3 = String.valueOf(String.valueOf(this.host));
        String string4 = String.valueOf(String.valueOf(url));
        log.log(Level.INFO, "Request: {0}", new StringBuilder(0 + string3.length() + string4.length()).append(string3).append(string4).toString());
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, this.errorTimeout);
    }

    private void checkContext() {
        if (this.urlSigner == null && this.apiKey == null) {
            throw new IllegalStateException("Must provide either API key or Maps for Business credentials.");
        }
        if (this.urlSigner == null && !this.apiKey.startsWith("AIza")) {
            throw new IllegalStateException("Invalid API key.");
        }
    }

    GeoApiContext setBaseUrl(String baseUrl) {
        this.host = baseUrl;
        return this;
    }

    public GeoApiContext setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public GeoApiContext setEnterpriseCredentials(String clientId, String cryptographicSecret) {
        this.clientId = clientId;
        this.urlSigner = new UrlSigner(cryptographicSecret);
        return this;
    }

    public GeoApiContext setConnectTimeout(long timeout, TimeUnit unit) {
        this.client.setConnectTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setReadTimeout(long timeout, TimeUnit unit) {
        this.client.setReadTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setWriteTimeout(long timeout, TimeUnit unit) {
        this.client.setWriteTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setRetryTimeout(long timeout, TimeUnit unit) {
        this.errorTimeout = unit.toMillis(timeout);
        return this;
    }

    public GeoApiContext setQueryRateLimit(int maxQps) {
        return this.setQueryRateLimit(maxQps, (int)(1.0 / (2.0 * (double)maxQps) * 1000.0));
    }

    public GeoApiContext setQueryRateLimit(int maxQps, int minimumInterval) {
        int n = maxQps;
        int n2 = minimumInterval;
        log.log(Level.INFO, new StringBuilder(88).append("Configuring rate limit at QPS: ").append(n).append(", minimum delay ").append(n2).append("ms between requests").toString());
        this.client.setDispatcher(new Dispatcher((ExecutorService)new RateLimitExecutorService(maxQps, minimumInterval)));
        return this;
    }
}

