/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnknownType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class UnionTypeBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_UNION_SIZE = 20;
    private final JSTypeRegistry registry;
    private final List<JSType> alternates = Lists.newArrayList();
    private boolean isAllType = false;
    private boolean isNativeUnknownType = false;
    private boolean areAllUnknownsChecked = true;
    private JSType result = null;
    private static final Comparator<JSType> typeSorter = new Comparator<JSType>(){

        @Override
        public int compare(JSType jSType, JSType jSType2) {
            return jSType2.hashCode() - jSType.hashCode();
        }
    };

    UnionTypeBuilder(JSTypeRegistry jSTypeRegistry) {
        this.registry = jSTypeRegistry;
    }

    Iterable<JSType> getAlternates() {
        JSType jSType = this.reduceAlternatesWithoutUnion();
        if (jSType != null) {
            return ImmutableList.of((Object)jSType);
        }
        return this.alternates;
    }

    UnionTypeBuilder addAlternate(JSType jSType) {
        if (jSType.isNoType()) {
            return this;
        }
        this.isAllType = this.isAllType || jSType.isAllType();
        boolean bl = jSType instanceof UnknownType;
        boolean bl2 = this.isNativeUnknownType = this.isNativeUnknownType || bl;
        if (bl) {
            boolean bl3 = this.areAllUnknownsChecked = this.areAllUnknownsChecked && jSType.isCheckedUnknownType();
        }
        if (!this.isAllType && !this.isNativeUnknownType) {
            if (jSType instanceof UnionType) {
                UnionType unionType = (UnionType)jSType;
                for (JSType jSType2 : unionType.getAlternates()) {
                    this.addAlternate(jSType2);
                }
            } else {
                if (this.alternates.size() > 20) {
                    return this;
                }
                Iterator<JSType> iterator = this.alternates.iterator();
                while (iterator.hasNext()) {
                    JSType jSType3 = iterator.next();
                    if (jSType.isUnknownType() || jSType3.isUnknownType()) {
                        if (!jSType.isEquivalentTo(jSType3)) continue;
                        return this;
                    }
                    if (jSType.isSubtype(jSType3)) {
                        return this;
                    }
                    if (!jSType3.isSubtype(jSType)) continue;
                    iterator.remove();
                }
                this.alternates.add(jSType);
                this.result = null;
            }
        } else {
            this.result = null;
        }
        return this;
    }

    private JSType reduceAlternatesWithoutUnion() {
        if (this.isAllType) {
            return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
        }
        if (this.isNativeUnknownType) {
            if (this.areAllUnknownsChecked) {
                return this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        int n = this.alternates.size();
        if (n > 20) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (n > 1) {
            return null;
        }
        if (n == 1) {
            return this.alternates.iterator().next();
        }
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    JSType build() {
        if (this.result == null) {
            this.result = this.reduceAlternatesWithoutUnion();
            if (this.result == null) {
                this.result = new UnionType(this.registry, this.getAlternateListCopy());
            }
        }
        return this.result;
    }

    private Collection<JSType> getAlternateListCopy() {
        Collections.sort(this.alternates, typeSorter);
        return ImmutableList.copyOf(this.alternates);
    }
}

