/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.UnionType;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class PrototypeObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Map<String, Property> properties = Maps.newTreeMap();
    private final boolean nativeType;
    private ObjectType implicitPrototypeFallback;
    private boolean prettyPrint = false;
    private static final int MAX_PRETTY_PRINTED_PROPERTIES = 4;

    PrototypeObjectType(JSTypeRegistry jSTypeRegistry, String string, ObjectType objectType) {
        this(jSTypeRegistry, string, objectType, false);
    }

    PrototypeObjectType(JSTypeRegistry jSTypeRegistry, String string, ObjectType objectType, boolean bl) {
        super(jSTypeRegistry);
        this.className = string;
        this.nativeType = bl;
        if (bl || objectType != null) {
            this.setImplicitPrototype(objectType);
        } else {
            this.setImplicitPrototype(jSTypeRegistry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
        }
    }

    @Override
    public int getPropertiesCount() {
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType == null) {
            return this.properties.size();
        }
        int n = 0;
        for (String string : this.properties.keySet()) {
            if (objectType.hasProperty(string)) continue;
            ++n;
        }
        return objectType.getPropertiesCount() + n;
    }

    @Override
    public boolean hasProperty(String string) {
        if (this.properties.get(string) != null) {
            return true;
        }
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            return objectType.hasProperty(string);
        }
        return false;
    }

    @Override
    public boolean hasOwnProperty(String string) {
        return this.properties.get(string) != null;
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean isPropertyTypeDeclared(String string) {
        Property property = this.properties.get(string);
        if (property == null) {
            ObjectType objectType = this.getImplicitPrototype();
            if (objectType != null) {
                return objectType.isPropertyTypeDeclared(string);
            }
            return false;
        }
        return !property.inferred;
    }

    @Override
    void collectPropertyNames(Set<String> set) {
        for (String string : this.properties.keySet()) {
            set.add(string);
        }
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            objectType.collectPropertyNames(set);
        }
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        Property property = this.properties.get(string);
        if (property == null) {
            ObjectType objectType = this.getImplicitPrototype();
            if (objectType != null) {
                return objectType.isPropertyTypeInferred(string);
            }
            return false;
        }
        return property.inferred;
    }

    @Override
    public JSType getPropertyType(String string) {
        Property property = this.properties.get(string);
        if (property != null) {
            return property.type;
        }
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            return objectType.getPropertyType(string);
        }
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public boolean isPropertyInExterns(String string) {
        Property property = this.properties.get(string);
        if (property != null) {
            return property.inExterns;
        }
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            return objectType.isPropertyInExterns(string);
        }
        return false;
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        if (this.hasOwnDeclaredProperty(string)) {
            return false;
        }
        this.properties.put(string, new Property(jSType, bl, bl2, node));
        return true;
    }

    @Override
    public Node getPropertyNode(String string) {
        Property property = this.properties.get(string);
        if (property != null) {
            return property.propertyNode;
        }
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            return objectType.getPropertyNode(string);
        }
        return null;
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String string) {
        Property property = this.properties.get(string);
        if (property != null) {
            return property.docInfo;
        }
        return null;
    }

    @Override
    public void setPropertyJSDocInfo(String string, JSDocInfo jSDocInfo, boolean bl) {
        if (jSDocInfo != null) {
            Property property;
            if (!this.properties.containsKey(string)) {
                this.defineInferredProperty(string, this.getPropertyType(string), bl, null);
            }
            if ((property = this.properties.get(string)) != null) {
                property.docInfo = jSDocInfo;
            }
        }
    }

    @Override
    public boolean matchesNumberContext() {
        return this.isNumberObjectType() || this.isDateType() || this.isBooleanObjectType() || this.isStringObjectType() || this.hasOverridenNativeProperty("valueOf");
    }

    @Override
    public boolean matchesStringContext() {
        return this.isTheObjectType() || this.isStringObjectType() || this.isDateType() || this.isRegexpType() || this.isArrayType() || this.isNumberObjectType() || this.isBooleanObjectType() || this.hasOverridenNativeProperty("toString");
    }

    private boolean hasOverridenNativeProperty(String string) {
        if (this.isNative()) {
            return false;
        }
        JSType jSType = this.getPropertyType(string);
        ObjectType objectType = this.isFunctionType() ? this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE) : this.registry.getNativeObjectType(JSTypeNative.OBJECT_PROTOTYPE);
        JSType jSType2 = objectType.getPropertyType(string);
        return jSType != jSType2;
    }

    @Override
    public JSType unboxesTo() {
        if (this.isStringObjectType()) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (this.isBooleanObjectType()) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (this.isNumberObjectType()) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        return super.unboxesTo();
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return this.isRegexpType();
    }

    boolean isNative() {
        return this.nativeType;
    }

    public String toString() {
        if (this.hasReferenceName()) {
            return this.getReferenceName();
        }
        if (this.prettyPrint) {
            Serializable serializable;
            TreeSet treeSet = Sets.newTreeSet();
            for (serializable = this; serializable != null && !((ObjectType)serializable).isNativeObjectType() && treeSet.size() <= 4; serializable = ((ObjectType)serializable).getImplicitPrototype()) {
                treeSet.addAll(((ObjectType)serializable).getOwnPropertyNames());
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("{");
            int n = 0;
            for (String string : treeSet) {
                if (n > 0) {
                    ((StringBuilder)serializable).append(", ");
                }
                ((StringBuilder)serializable).append(string);
                ((StringBuilder)serializable).append(": ");
                ((StringBuilder)serializable).append(this.getPropertyType(string).toString());
                if (++n != 4) continue;
                ((StringBuilder)serializable).append(", ...");
                break;
            }
            ((StringBuilder)serializable).append("}");
            return ((StringBuilder)serializable).toString();
        }
        return "{...}";
    }

    void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.implicitPrototypeFallback;
    }

    final void setImplicitPrototype(ObjectType objectType) {
        Preconditions.checkState((!this.hasCachedValues() ? 1 : 0) != 0);
        this.implicitPrototypeFallback = objectType;
    }

    @Override
    public String getReferenceName() {
        if (this.className != null) {
            return this.className;
        }
        return null;
    }

    @Override
    public boolean hasReferenceName() {
        return this.className != null;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        FunctionType functionType;
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        if (jSType instanceof UnionType) {
            return false;
        }
        if (jSType instanceof RecordType) {
            return RecordType.isSubtype(this, (RecordType)jSType);
        }
        ObjectType objectType = jSType.toObjectType();
        FunctionType functionType2 = functionType = objectType == null ? null : objectType.getConstructor();
        if (functionType != null && ((JSType)functionType).isInterface()) {
            Iterable<ObjectType> iterable = this.getCtorImplementedInterfaces();
            for (ObjectType objectType2 : iterable) {
                if (!objectType2.isSubtype(jSType)) continue;
                return true;
            }
        }
        if (jSType != null) {
            if (this.isUnknownType() || this.implicitPrototypeChainIsUnknown()) {
                return true;
            }
            return this.isImplicitPrototype(objectType);
        }
        return false;
    }

    private boolean implicitPrototypeChainIsUnknown() {
        for (ObjectType objectType = this.getImplicitPrototype(); objectType != null; objectType = objectType.getImplicitPrototype()) {
            if (!objectType.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCachedValues() {
        return super.hasCachedValues();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.nativeType;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.setResolvedTypeInternal(this);
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null) {
            this.implicitPrototypeFallback = (ObjectType)objectType.resolve(errorReporter, staticScope);
        }
        for (Property property : this.properties.values()) {
            property.type = PrototypeObjectType.safeResolve(property.type, errorReporter, staticScope);
        }
        return this;
    }

    private static final class Property
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private JSType type;
        private final boolean inferred;
        private final boolean inExterns;
        private final Node propertyNode;
        private JSDocInfo docInfo = null;

        private Property(JSType jSType, boolean bl, boolean bl2, Node node) {
            this.type = jSType;
            this.inferred = bl;
            this.inExterns = bl2;
            this.propertyNode = node;
        }
    }
}

