/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RenamePrototypes
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean aggressiveRenaming;
    private final char[] reservedCharacters;
    private final VariableMap prevUsedRenameMap;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property property, Property property2) {
            int n;
            int n2 = property.count();
            if (n2 != (n = property2.count())) {
                return n - n2;
            }
            return property.oldName.compareTo(property2.oldName);
        }
    };
    private final Set<Node> stringNodes = new HashSet<Node>();
    private final Map<String, Property> properties = new HashMap<String, Property>();
    private final Set<String> reservedNames = new HashSet<String>(Arrays.asList("indexOf", "lastIndexOf", "toString", "valueOf"));
    private final Set<Node> prototypeObjLits = new HashSet<Node>();

    RenamePrototypes(AbstractCompiler abstractCompiler, boolean bl, @Nullable char[] cArray, @Nullable VariableMap variableMap) {
        this.compiler = abstractCompiler;
        this.aggressiveRenaming = bl;
        this.reservedCharacters = cArray;
        this.prevUsedRenameMap = variableMap;
    }

    @Override
    public void process(Node node, Node node2) {
        Object object;
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, node, new ProcessExternedProperties());
        NodeTraversal.traverse(this.compiler, node2, new ProcessProperties());
        TreeSet<Property> treeSet = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        Object object2 = this.properties.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next().getValue();
            if (((Property)object).canRename() && !this.reservedNames.contains(((Property)object).oldName)) {
                treeSet.add((Property)object);
                continue;
            }
            object2.remove();
            this.reservedNames.add(((Property)object).oldName);
        }
        if (this.prevUsedRenameMap != null) {
            this.reusePrototypeNames(treeSet);
        }
        object2 = new NameGenerator(this.reservedNames, "", this.reservedCharacters);
        object = new StringBuilder();
        for (Property object3 : treeSet) {
            if (object3.newName == null) {
                object3.newName = ((NameGenerator)object2).generateNextName();
                this.reservedNames.add(object3.newName);
            }
            ((StringBuilder)object).append(object3.oldName).append(" => ").append(object3.newName).append('\n');
        }
        this.compiler.addToDebugLog("JS property assignments:\n" + object);
        boolean bl = false;
        for (Node node3 : this.stringNodes) {
            String string = node3.getString();
            Property property = this.properties.get(string);
            if (property == null || property.newName == null) continue;
            node3.setString(property.newName);
            bl = bl || !property.newName.equals(string);
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED_OBFUSCATED);
    }

    private void reusePrototypeNames(Set<Property> set) {
        for (Property property : set) {
            String string = this.prevUsedRenameMap.lookupNewName(property.oldName);
            if (string == null || this.reservedNames.contains(string)) continue;
            property.newName = string;
            this.reservedNames.add(string);
        }
    }

    VariableMap getPropertyMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Property property : this.properties.values()) {
            if (property.newName == null) continue;
            hashMap.put(property.oldName, property.newName);
        }
        return new VariableMap(hashMap);
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    String string = node3.getString();
                    if (string.equals("prototype")) {
                        this.processPrototypeParent(node2, nodeTraversal.getInput());
                        break;
                    }
                    this.markPropertyAccessCandidate(node3, nodeTraversal.getInput());
                    break;
                }
                case 64: {
                    if (RenamePrototypes.this.prototypeObjLits.contains(node)) break;
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() == 39) continue;
                        this.markObjLitPropertyCandidate(node4, nodeTraversal.getInput());
                    }
                    break;
                }
            }
        }

        private void processPrototypeParent(Node node, CompilerInput compilerInput) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node2 = node.getFirstChild().getNext();
                    if (node2.getType() != 40) break;
                    this.markPrototypePropertyCandidate(node2, compilerInput);
                    break;
                }
                case 37: 
                case 86: {
                    Node node3 = node.getType() == 86 ? node.getFirstChild().getNext() : node.getLastChild();
                    if (node3.getType() != 64) break;
                    RenamePrototypes.this.prototypeObjLits.add(node3);
                    for (Node node4 = node3.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() == 39) continue;
                        this.markPrototypePropertyCandidate(node4, compilerInput);
                    }
                    break;
                }
            }
        }

        private void markPrototypePropertyCandidate(Node node, CompilerInput compilerInput) {
            RenamePrototypes.this.stringNodes.add(node);
            ++this.getProperty((String)node.getString()).prototypeCount;
        }

        private void markObjLitPropertyCandidate(Node node, CompilerInput compilerInput) {
            RenamePrototypes.this.stringNodes.add(node);
            ++this.getProperty((String)node.getString()).objLitCount;
        }

        private void markPropertyAccessCandidate(Node node, CompilerInput compilerInput) {
            RenamePrototypes.this.stringNodes.add(node);
            ++this.getProperty((String)node.getString()).refCount;
        }

        private Property getProperty(String string) {
            Property property = (Property)RenamePrototypes.this.properties.get(string);
            if (property == null) {
                property = new Property(string);
                RenamePrototypes.this.properties.put(string, property);
            }
            return property;
        }
    }

    private class ProcessExternedProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternedProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    RenamePrototypes.this.reservedNames.add(node3.getString());
                }
            }
        }
    }

    private class Property {
        String oldName;
        String newName;
        int prototypeCount;
        int objLitCount;
        int refCount;

        Property(String string) {
            this.oldName = string;
            this.newName = null;
            this.prototypeCount = 0;
            this.objLitCount = 0;
            this.refCount = 0;
        }

        int count() {
            return this.prototypeCount + this.objLitCount + this.refCount;
        }

        boolean canRename() {
            if (this.prototypeCount > 0 && this.objLitCount == 0) {
                return this.canRenamePrototypeProperty();
            }
            if (this.objLitCount > 0 && this.prototypeCount == 0) {
                return this.canRenameObjLitProperty();
            }
            return this.canRenamePrototypeProperty() && this.canRenameObjLitProperty();
        }

        private boolean canRenamePrototypeProperty() {
            if (RenamePrototypes.this.compiler.getCodingConvention().isExported(this.oldName)) {
                return false;
            }
            if (RenamePrototypes.this.compiler.getCodingConvention().isPrivate(this.oldName)) {
                return true;
            }
            if (RenamePrototypes.this.aggressiveRenaming) {
                return true;
            }
            int n = this.oldName.length();
            for (int i = 0; i < n; ++i) {
                char c = this.oldName.charAt(i);
                if (!Character.isUpperCase(c) && Character.isLetter(c)) continue;
                return true;
            }
            return false;
        }

        private boolean canRenameObjLitProperty() {
            if (RenamePrototypes.this.compiler.getCodingConvention().isExported(this.oldName)) {
                return false;
            }
            return RenamePrototypes.this.compiler.getCodingConvention().isPrivate(this.oldName);
        }
    }
}

