/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PassConfig {
    final CompilerOptions options;
    MemoizedScopeCreator typedScopeCreator;
    Scope topScope = null;

    public PassConfig(CompilerOptions compilerOptions) {
        this.options = compilerOptions;
    }

    void regenerateGlobalTypedScope(AbstractCompiler abstractCompiler, Node node) {
        this.typedScopeCreator = new MemoizedScopeCreator(new TypedScopeCreator(abstractCompiler));
        this.topScope = this.typedScopeCreator.createScope(node, null);
    }

    ScopeCreator getScopeCreator() {
        return this.typedScopeCreator;
    }

    Scope getTopScope() {
        return this.topScope;
    }

    protected abstract List<PassFactory> getChecks();

    protected abstract List<PassFactory> getOptimizations();

    GraphvizGraph getPassGraph() {
        LinkedDirectedGraph<String, String> linkedDirectedGraph = LinkedDirectedGraph.createWithoutAnnotations();
        Iterable iterable = Iterables.concat(this.getChecks(), this.getOptimizations());
        String string = null;
        String string2 = null;
        for (PassFactory passFactory : iterable) {
            String string3 = passFactory.getName();
            int n = 1;
            while (linkedDirectedGraph.hasNode(string3)) {
                string3 = passFactory.getName() + n++;
            }
            linkedDirectedGraph.createNode(string3);
            if (string2 == null && !passFactory.isOneTimePass()) {
                string2 = string3;
            } else if (string2 != null && passFactory.isOneTimePass()) {
                linkedDirectedGraph.connect(string, "loop", string2);
                string2 = null;
            }
            if (string != null) {
                linkedDirectedGraph.connect(string, "", string3);
            }
            string = string3;
        }
        return linkedDirectedGraph;
    }

    final TypeInferencePass makeTypeInference(AbstractCompiler abstractCompiler) {
        return new TypeInferencePass(abstractCompiler, abstractCompiler.getReverseAbstractInterpreter(), this.topScope, this.typedScopeCreator);
    }

    final TypeCheck makeTypeCheck(AbstractCompiler abstractCompiler) {
        return new TypeCheck(abstractCompiler, abstractCompiler.getReverseAbstractInterpreter(), abstractCompiler.getTypeRegistry(), this.topScope, this.typedScopeCreator, this.options.reportMissingOverride, this.options.reportUnknownTypes).reportMissingProperties(this.options.enables(DiagnosticGroup.forType(TypeCheck.INEXISTENT_PROPERTY)));
    }

    static final void addPassFactoryBefore(List<PassFactory> list, PassFactory passFactory, String string) {
        list.add(PassConfig.findPassIndexByName(list, string), passFactory);
    }

    static final void replacePassFactory(List<PassFactory> list, PassFactory passFactory) {
        list.set(PassConfig.findPassIndexByName(list, passFactory.getName()), passFactory);
    }

    private static int findPassIndexByName(List<PassFactory> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("No factory named '" + string + "' in the factory list");
    }

    final PassConfig getBasePassConfig() {
        PassConfig passConfig = this;
        while (passConfig instanceof PassConfigDelegate) {
            passConfig = ((PassConfigDelegate)passConfig).delegate;
        }
        return passConfig;
    }

    abstract State getIntermediateState();

    abstract void setIntermediateState(State var1);

    static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Map<String, Integer> cssNames;
        final Set<String> exportedNames;
        final CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator;
        final VariableMap variableMap;
        final VariableMap propertyMap;
        final VariableMap anonymousFunctionNameMap;
        final VariableMap stringMap;
        final FunctionNames functionNames;
        final String idGeneratorMap;

        State(Map<String, Integer> map, Set<String> set, CrossModuleMethodMotion.IdGenerator idGenerator, VariableMap variableMap, VariableMap variableMap2, VariableMap variableMap3, VariableMap variableMap4, FunctionNames functionNames, String string) {
            this.cssNames = map;
            this.exportedNames = set;
            this.crossModuleIdGenerator = idGenerator;
            this.variableMap = variableMap;
            this.propertyMap = variableMap2;
            this.anonymousFunctionNameMap = variableMap3;
            this.stringMap = variableMap4;
            this.idGeneratorMap = string;
            this.functionNames = functionNames;
        }
    }

    static class PassConfigDelegate
    extends PassConfig {
        private final PassConfig delegate;

        PassConfigDelegate(PassConfig passConfig) {
            super(passConfig.options);
            this.delegate = passConfig;
        }

        @Override
        protected List<PassFactory> getChecks() {
            return this.delegate.getChecks();
        }

        @Override
        protected List<PassFactory> getOptimizations() {
            return this.delegate.getOptimizations();
        }

        @Override
        ScopeCreator getScopeCreator() {
            return this.delegate.getScopeCreator();
        }

        @Override
        Scope getTopScope() {
            return this.delegate.getTopScope();
        }

        @Override
        State getIntermediateState() {
            return this.delegate.getIntermediateState();
        }

        @Override
        void setIntermediateState(State state) {
            this.delegate.setIntermediateState(state);
        }
    }
}

