/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Deque;
import java.util.List;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final String ARGUMENTS = "arguments";
    private static final String PARAMETER_PREFIX = "JSCompiler_OptimizeArgumentsArray_p";
    private final String paramPredix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = Lists.newLinkedList();
    private List<Node> currentArgumentsAccess = null;

    OptimizeArgumentsArray(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, PARAMETER_PREFIX);
    }

    OptimizeArgumentsArray(AbstractCompiler abstractCompiler, String string) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)abstractCompiler);
        this.paramPredix = (String)Preconditions.checkNotNull((Object)string);
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, (Node)Preconditions.checkNotNull((Object)node2), this);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Preconditions.checkNotNull((Object)nodeTraversal);
        Node node = nodeTraversal.getScopeRoot();
        if (!NodeUtil.isFunction(node)) {
            return;
        }
        if (this.currentArgumentsAccess != null) {
            this.argumentsAccessStack.push(this.currentArgumentsAccess);
        }
        this.currentArgumentsAccess = Lists.newLinkedList();
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        Preconditions.checkNotNull((Object)nodeTraversal);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (this.tryReplaceArguments(nodeTraversal.getScope())) {
            nodeTraversal.getCompiler().reportCodeChange();
        }
        this.currentArgumentsAccess = !this.argumentsAccessStack.isEmpty() ? this.argumentsAccessStack.pop() : null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        Preconditions.checkNotNull((Object)nodeTraversal);
        Preconditions.checkNotNull((Object)node);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (NodeUtil.isName(node) && ARGUMENTS.equals(node.getString())) {
            this.currentArgumentsAccess.add(node);
        }
    }

    private boolean tryReplaceArguments(Scope scope) {
        int n;
        Node node;
        Node node2 = scope.getRootNode().getFirstChild().getNext();
        Preconditions.checkState((node2.getType() == 83 ? 1 : 0) != 0);
        boolean bl = false;
        int n2 = node2.getChildCount();
        int n3 = n2 - 1;
        for (Node stringArray2 : this.currentArgumentsAccess) {
            Node i = stringArray2.getParent();
            if (i.getType() != 35) {
                return false;
            }
            Node node3 = stringArray2.getNext();
            if (node3.getType() != 39) {
                return false;
            }
            node = i.getParent();
            if (NodeUtil.isCall(node) && node.getFirstChild() == i) {
                return false;
            }
            n = (int)node3.getDouble();
            if (n <= n3) continue;
            n3 = n;
        }
        int n4 = n3 - n2 + 1;
        String[] stringArray = new String[n4];
        for (int i = 0; i < n4; ++i) {
            String string;
            stringArray[i] = string = this.getNewName();
            node2.addChildrenToBack(Node.newString(38, string));
            bl = true;
        }
        for (Node node4 : this.currentArgumentsAccess) {
            node = node4.getNext();
            if (node.getType() != 39) continue;
            n = (int)node.getDouble();
            if (n >= n2) {
                node4.getParent().getParent().replaceChild(node4.getParent(), Node.newString(38, stringArray[n - n2]));
            } else {
                Node node5 = node2.getFirstChild();
                for (int i = 0; i < n; ++i) {
                    node5 = node5.getNext();
                }
                node4.getParent().getParent().replaceChild(node4.getParent(), Node.newString(38, node5.getString()));
            }
            bl = true;
        }
        return bl;
    }

    private String getNewName() {
        return this.paramPredix + this.uniqueId++;
    }
}

