/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class FunctionTypeBuilder {
    private final String fnName;
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final Node errorRoot;
    private final String sourceName;
    private final Scope scope;
    private JSType returnType = null;
    private boolean returnTypeInferred = false;
    private List<ObjectType> implementedInterfaces = null;
    private ObjectType baseType = null;
    private ObjectType thisType = null;
    private boolean isConstructor = false;
    private boolean isInterface = false;
    private Node parametersNode = null;
    private Node sourceNode = null;
    private String templateTypeName = null;
    static final DiagnosticType EXTENDS_WITHOUT_TYPEDEF = DiagnosticType.warning("JSC_EXTENDS_WITHOUT_TYPEDEF", "@extends used without @constructor or @interface for {0}");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} @extends non-object type {1}");
    static final DiagnosticType RESOLVED_TAG_EMPTY = DiagnosticType.warning("JSC_RESOLVED_TAG_EMPTY", "Could not resolve type in {0} tag of {1}");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType VAR_ARGS_MUST_BE_LAST = DiagnosticType.warning("JSC_VAR_ARGS_MUST_BE_LAST", "variable length argument must be last");
    static final DiagnosticType OPTIONAL_ARG_AT_END = DiagnosticType.warning("JSC_OPTIONAL_ARG_AT_END", "optional arguments must be at the end");
    static final DiagnosticType INEXISTANT_PARAM = DiagnosticType.warning("JSC_INEXISTANT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType TYPE_REDEFINITION = DiagnosticType.warning("JSC_TYPE_REDEFINITION", "attempted re-definition of type {0}\nfound   : {1}\nexpected: {2}");
    static final DiagnosticType TEMPLATE_TYPE_DUPLICATED = DiagnosticType.error("JSC_TEMPLATE_TYPE_DUPLICATED", "Only one parameter type must be the template type");
    static final DiagnosticType TEMPLATE_TYPE_EXPECTED = DiagnosticType.error("JSC_TEMPLATE_TYPE_EXPECTED", "The template type must be a parameter type");
    static final DiagnosticType THIS_TYPE_NON_OBJECT = DiagnosticType.warning("JSC_THIS_TYPE_NON_OBJECT", "@this type of a function must be an object\nActual type: {0}");

    FunctionTypeBuilder(String string, AbstractCompiler abstractCompiler, Node node, String string2, Scope scope) {
        Preconditions.checkNotNull((Object)node);
        this.fnName = string == null ? "" : string;
        this.codingConvention = abstractCompiler.getCodingConvention();
        this.typeRegistry = abstractCompiler.getTypeRegistry();
        this.errorRoot = node;
        this.sourceName = string2;
        this.compiler = abstractCompiler;
        this.scope = scope;
    }

    FunctionTypeBuilder setSourceNode(@Nullable Node node) {
        this.sourceNode = node;
        return this;
    }

    FunctionTypeBuilder inferFromOverriddenFunction(@Nullable FunctionType functionType, @Nullable Node node) {
        if (functionType == null) {
            return this;
        }
        this.returnType = functionType.getReturnType();
        this.returnTypeInferred = functionType.isReturnTypeInferred();
        if (node == null) {
            this.parametersNode = functionType.getParametersNode();
            if (this.parametersNode == null) {
                this.parametersNode = new FunctionParamBuilder(this.typeRegistry).build();
            }
        } else {
            FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(this.typeRegistry);
            Iterator<Node> iterator = functionType.getParameters().iterator();
            boolean bl = false;
            boolean bl2 = false;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (iterator.hasNext()) {
                    Node node3 = iterator.next();
                    Node node4 = functionParamBuilder.newParameterFromNode(node3);
                    boolean bl3 = bl2 = bl2 || node3.isVarArgs() || node3.isOptionalArg();
                    if (node2.getNext() == null || !node4.isVarArgs()) continue;
                    node4.setVarArgs(false);
                    node4.setOptionalArg(true);
                    continue;
                }
                bl |= this.addParameter(functionParamBuilder, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE), bl, this.codingConvention.isOptionalParameter(node2) || bl2, this.codingConvention.isVarArgsParameter(node2));
            }
            this.parametersNode = functionParamBuilder.build();
        }
        return this;
    }

    FunctionTypeBuilder inferReturnType(@Nullable JSDocInfo jSDocInfo) {
        if (jSDocInfo != null && jSDocInfo.hasReturnType()) {
            this.returnType = jSDocInfo.getReturnType().evaluate(this.scope, this.typeRegistry);
            this.returnTypeInferred = false;
        }
        if (this.templateTypeName != null && this.returnType != null && this.returnType.restrictByNotNullOrUndefined().isTemplateType()) {
            this.reportError(TEMPLATE_TYPE_EXPECTED, this.fnName);
        }
        return this;
    }

    FunctionTypeBuilder inferReturnStatementsAsLastResort(@Nullable Node node) {
        if (node == null || this.compiler.getInput(this.sourceName).isExtern()) {
            return this;
        }
        Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
        if (this.returnType == null) {
            boolean bl = false;
            ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{node});
            while (!arrayList.isEmpty()) {
                Node node2 = (Node)arrayList.remove(arrayList.size() - 1);
                int n = node2.getType();
                if (n == 4 && node2.getFirstChild() != null || n == 49) {
                    bl = true;
                    break;
                }
                if (!NodeUtil.isStatementBlock(node2) && !NodeUtil.isControlStructure(node2)) continue;
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    arrayList.add(node3);
                }
            }
            if (!bl) {
                this.returnType = this.typeRegistry.getNativeType(JSTypeNative.VOID_TYPE);
                this.returnTypeInferred = true;
            }
        }
        return this;
    }

    FunctionTypeBuilder inferInheritance(@Nullable JSDocInfo jSDocInfo) {
        if (jSDocInfo != null) {
            Object object;
            this.isConstructor = jSDocInfo.isConstructor();
            this.isInterface = jSDocInfo.isInterface();
            if (jSDocInfo.hasBaseType()) {
                if (this.isConstructor || this.isInterface) {
                    object = jSDocInfo.getBaseType().evaluate(this.scope, this.typeRegistry);
                    if (object != null && ((JSType)object).setValidator(new ExtendedTypeValidator())) {
                        this.baseType = (ObjectType)object;
                    }
                } else {
                    this.reportWarning(EXTENDS_WITHOUT_TYPEDEF, this.fnName);
                }
            }
            if (this.isConstructor || this.isInterface) {
                Serializable serializable;
                this.implementedInterfaces = Lists.newArrayList();
                object = jSDocInfo.getImplementedInterfaces().iterator();
                while (object.hasNext()) {
                    serializable = (JSTypeExpression)object.next();
                    JSType jSType = ((JSTypeExpression)serializable).evaluate(this.scope, this.typeRegistry);
                    if (jSType == null || !jSType.setValidator(new ImplementedTypeValidator())) continue;
                    this.implementedInterfaces.add((ObjectType)jSType);
                }
                if (this.baseType != null && (object = this.baseType.getConstructor()) instanceof FunctionType) {
                    serializable = this.baseType.getConstructor();
                    Iterables.addAll(this.implementedInterfaces, ((FunctionType)serializable).getImplementedInterfaces());
                }
            } else if (jSDocInfo.getImplementedInterfaceCount() > 0) {
                this.reportWarning(IMPLEMENTS_WITHOUT_CONSTRUCTOR, this.fnName);
            }
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo jSDocInfo, JSType jSType) {
        ObjectType objectType = ObjectType.cast(jSType);
        if (!(objectType == null || jSDocInfo != null && jSDocInfo.hasType())) {
            this.thisType = objectType;
        }
        return this;
    }

    FunctionTypeBuilder inferThisType(JSDocInfo jSDocInfo, @Nullable Node node) {
        String string;
        ObjectType objectType;
        ObjectType objectType2 = null;
        if (jSDocInfo != null && jSDocInfo.hasThisType()) {
            objectType2 = ObjectType.cast(jSDocInfo.getThisType().evaluate(this.scope, this.typeRegistry));
        }
        if (objectType2 != null) {
            this.thisType = objectType2;
            this.thisType.setValidator(new ThisTypeValidator());
        } else if (!(node == null || jSDocInfo != null && jSDocInfo.hasType() || (objectType = ObjectType.cast(this.typeRegistry.getForgivingType(this.scope, string = node.getQualifiedName(), this.sourceName, node.getLineno(), node.getCharno()))) == null)) {
            this.thisType = objectType;
        }
        return this;
    }

    FunctionTypeBuilder inferParameterTypes(JSDocInfo jSDocInfo) {
        Node node = new Node(83);
        for (String string : jSDocInfo.getParameterNames()) {
            node.addChildToBack(Node.newString(38, string));
        }
        return this.inferParameterTypes(node, jSDocInfo);
    }

    FunctionTypeBuilder inferParameterTypes(@Nullable Node node, @Nullable JSDocInfo jSDocInfo) {
        if (node == null) {
            if (jSDocInfo == null) {
                return this;
            }
            return this.inferParameterTypes(jSDocInfo);
        }
        Node node2 = null;
        if (this.parametersNode != null) {
            node2 = this.parametersNode.getFirstChild();
        }
        FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(this.typeRegistry);
        boolean bl = false;
        HashSet hashSet = jSDocInfo == null ? Sets.newHashSet() : Sets.newHashSet(jSDocInfo.getParameterNames());
        boolean bl2 = false;
        for (Node object : node.children()) {
            String string = object.getString();
            hashSet.remove(string);
            JSType jSType = null;
            boolean bl3 = this.isOptionalParameter(object, jSDocInfo);
            boolean bl4 = this.isVarArgsParameter(object, jSDocInfo);
            if (jSDocInfo != null && jSDocInfo.hasParameterType(string)) {
                jSType = jSDocInfo.getParameterType(string).evaluate(this.scope, this.typeRegistry);
            } else if (node2 != null && node2.getJSType() != null) {
                jSType = node2.getJSType();
                bl3 = node2.isOptionalArg();
                bl4 = node2.isVarArgs();
            } else {
                jSType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            if (this.templateTypeName != null && jSType.restrictByNotNullOrUndefined().isTemplateType()) {
                if (bl2) {
                    this.reportError(TEMPLATE_TYPE_DUPLICATED, this.fnName);
                }
                bl2 = true;
            }
            bl |= this.addParameter(functionParamBuilder, jSType, bl, bl3, bl4);
            if (node2 == null) continue;
            node2 = node2.getNext();
        }
        if (this.templateTypeName != null && !bl2) {
            this.reportError(TEMPLATE_TYPE_EXPECTED, this.fnName);
        }
        for (String string : hashSet) {
            this.reportWarning(INEXISTANT_PARAM, string, this.fnName);
        }
        this.parametersNode = functionParamBuilder.build();
        return this;
    }

    private boolean isOptionalParameter(Node node, @Nullable JSDocInfo jSDocInfo) {
        if (this.codingConvention.isOptionalParameter(node)) {
            return true;
        }
        String string = node.getString();
        return jSDocInfo != null && jSDocInfo.hasParameterType(string) && jSDocInfo.getParameterType(string).isOptionalArg();
    }

    private boolean isVarArgsParameter(Node node, @Nullable JSDocInfo jSDocInfo) {
        if (this.codingConvention.isVarArgsParameter(node)) {
            return true;
        }
        String string = node.getString();
        return jSDocInfo != null && jSDocInfo.hasParameterType(string) && jSDocInfo.getParameterType(string).isVarArgs();
    }

    FunctionTypeBuilder inferTemplateTypeName(@Nullable JSDocInfo jSDocInfo) {
        if (jSDocInfo != null) {
            this.templateTypeName = jSDocInfo.getTemplateTypeName();
            this.typeRegistry.setTemplateTypeName(this.templateTypeName);
        }
        return this;
    }

    private boolean addParameter(FunctionParamBuilder functionParamBuilder, JSType jSType, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (bl2) {
            if (!functionParamBuilder.addOptionalParams(jSType) && !bl) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                bl4 = true;
            }
        } else if (bl3) {
            if (!functionParamBuilder.addVarArgs(jSType) && !bl) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                bl4 = true;
            }
        } else if (!functionParamBuilder.addRequiredParams(jSType) && !bl) {
            if (functionParamBuilder.hasVarArgs()) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
            } else {
                this.reportWarning(OPTIONAL_ARG_AT_END, new String[0]);
            }
            bl4 = true;
        }
        return bl4;
    }

    FunctionType buildAndRegister() {
        FunctionType functionType;
        if (this.returnType == null) {
            this.returnType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.parametersNode == null) {
            throw new IllegalStateException("All Function types must have params and a return type");
        }
        if (this.isConstructor) {
            functionType = this.getOrCreateConstructor();
        } else if (this.isInterface) {
            functionType = this.typeRegistry.createInterfaceType(this.fnName, this.sourceNode);
            if (this.getScopeDeclaredIn().isGlobal() && !this.fnName.isEmpty()) {
                this.typeRegistry.declareType(this.fnName, functionType.getInstanceType());
            }
            this.maybeSetBaseType(functionType);
        } else {
            functionType = new FunctionBuilder(this.typeRegistry).withName(this.fnName).withSourceNode(this.sourceNode).withParamsNode(this.parametersNode).withReturnType(this.returnType, this.returnTypeInferred).withTypeOfThis(this.thisType).withTemplateName(this.templateTypeName).build();
            this.maybeSetBaseType(functionType);
        }
        if (this.implementedInterfaces != null) {
            functionType.setImplementedInterfaces(this.implementedInterfaces);
        }
        this.typeRegistry.clearTemplateTypeName();
        return functionType;
    }

    private void maybeSetBaseType(FunctionType functionType) {
        if (this.baseType != null) {
            functionType.setPrototypeBasedOn(this.baseType);
        }
    }

    private FunctionType getOrCreateConstructor() {
        boolean bl;
        FunctionType functionType = this.typeRegistry.createConstructorType(this.fnName, this.sourceNode, this.parametersNode, this.returnType);
        JSType jSType = this.typeRegistry.getType(this.fnName);
        if (jSType != null && ((bl = jSType instanceof InstanceObjectType) || this.fnName.equals("Function"))) {
            FunctionType functionType2;
            FunctionType functionType3 = functionType2 = bl ? ((InstanceObjectType)jSType).getConstructor() : this.typeRegistry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            if (functionType2.getSource() == null) {
                functionType2.setSource(this.sourceNode);
            }
            if (!functionType2.hasEqualCallType(functionType)) {
                this.reportWarning(TYPE_REDEFINITION, this.fnName, functionType.toString(), functionType2.toString());
            }
            return functionType2;
        }
        this.maybeSetBaseType(functionType);
        if (this.getScopeDeclaredIn().isGlobal() && !this.fnName.isEmpty()) {
            this.typeRegistry.declareType(this.fnName, functionType.getInstanceType());
        }
        return functionType;
    }

    private void reportWarning(DiagnosticType diagnosticType, String ... stringArray) {
        this.compiler.report(JSError.make(this.sourceName, this.errorRoot, diagnosticType, stringArray));
    }

    private void reportError(DiagnosticType diagnosticType, String ... stringArray) {
        this.compiler.report(JSError.make(this.sourceName, this.errorRoot, diagnosticType, stringArray));
    }

    static boolean isFunctionTypeDeclaration(JSDocInfo jSDocInfo) {
        return jSDocInfo.getParameterCount() > 0 || jSDocInfo.hasReturnType() || jSDocInfo.hasThisType() || jSDocInfo.isConstructor() || jSDocInfo.isInterface();
    }

    private Scope getScopeDeclaredIn() {
        String string;
        Scope.Var var;
        int n = this.fnName.indexOf(".");
        if (n != -1 && (var = this.scope.getVar(string = this.fnName.substring(0, n))) != null) {
            return var.getScope();
        }
        return this.scope;
    }

    private class ThisTypeValidator
    implements Predicate<JSType> {
        private ThisTypeValidator() {
        }

        public boolean apply(JSType jSType) {
            if (!jSType.restrictByNotNullOrUndefined().isSubtype(FunctionTypeBuilder.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                FunctionTypeBuilder.this.reportWarning(THIS_TYPE_NON_OBJECT, new String[]{jSType.toString()});
                return false;
            }
            return true;
        }
    }

    private class ImplementedTypeValidator
    implements Predicate<JSType> {
        private ImplementedTypeValidator() {
        }

        public boolean apply(JSType jSType) {
            ObjectType objectType = ObjectType.cast(jSType);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportError(TypeCheck.BAD_IMPLEMENTED_TYPE, new String[]{FunctionTypeBuilder.this.fnName});
            } else if (objectType.isUnknownType() && (objectType.getImplicitPrototype() == null || objectType.getImplicitPrototype().isResolved())) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@implements", FunctionTypeBuilder.this.fnName});
            } else {
                return true;
            }
            return false;
        }
    }

    private class ExtendedTypeValidator
    implements Predicate<JSType> {
        private ExtendedTypeValidator() {
        }

        public boolean apply(JSType jSType) {
            ObjectType objectType = ObjectType.cast(jSType);
            if (objectType == null) {
                FunctionTypeBuilder.this.reportWarning(EXTENDS_NON_OBJECT, new String[]{FunctionTypeBuilder.this.fnName, jSType.toString()});
            } else if (objectType.isUnknownType() && (objectType.getImplicitPrototype() == null || objectType.getImplicitPrototype().isResolved())) {
                FunctionTypeBuilder.this.reportWarning(RESOLVED_TAG_EMPTY, new String[]{"@extends", FunctionTypeBuilder.this.fnName});
            } else {
                return true;
            }
            return false;
        }
    }
}

