/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.escape;

import com.google.api.client.util.escape.Escaper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PercentEncodedEscaper
extends Escaper {
    static final Pattern PCT_ENCODE_PATTERN = Pattern.compile("%[0-9A-Fa-f]{2}");
    private final Escaper escaper;

    public PercentEncodedEscaper(Escaper escaper) {
        if (escaper == null) {
            throw new NullPointerException("Escaper cannot be null");
        }
        this.escaper = escaper;
    }

    @Override
    public String escape(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        Matcher matcher = PCT_ENCODE_PATTERN.matcher(string);
        StringBuilder sb = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(this.escaper.escape(string.substring(lastEnd, matcher.start())));
            sb.append(string.substring(matcher.start(), matcher.end()));
            lastEnd = matcher.end();
        }
        if (lastEnd < string.length()) {
            sb.append(this.escaper.escape(string.substring(lastEnd)));
        }
        return sb.toString();
    }
}

