/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.compiler.schema.ContentFamilyVisitor;

public enum ContentFamily {
    CSS{

        @Override
        public <K, V> V acceptVisitor(ContentFamilyVisitor<K, V> visitor, K arg) {
            return visitor.visitCss(arg);
        }
    }
    ,
    JAVA_SCRIPT{

        @Override
        public <K, V> V acceptVisitor(ContentFamilyVisitor<K, V> visitor, K arg) {
            return visitor.visitJavaScript(arg);
        }
    }
    ,
    MARKUP{

        @Override
        public <K, V> V acceptVisitor(ContentFamilyVisitor<K, V> visitor, K arg) {
            return visitor.visitMarkup(arg);
        }
    }
    ,
    PLAINTEXT{

        @Override
        public <K, V> V acceptVisitor(ContentFamilyVisitor<K, V> visitor, K arg) {
            return visitor.visitPlaintext(arg);
        }
    };


    public abstract <K, V> V acceptVisitor(ContentFamilyVisitor<K, V> var1, K var2);

    public static ContentFamily fromContentTypeName(String contentTypeName) {
        if ("text/javascript".equals(contentTypeName)) {
            return JAVA_SCRIPT;
        }
        if ("text/css".equals(contentTypeName)) {
            return CSS;
        }
        if ("text/plain".equals(contentTypeName)) {
            return PLAINTEXT;
        }
        return MARKUP;
    }
}

