/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.codegen;

import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.IllegalExpressionError;
import com.google.gxp.compiler.codegen.IllegalNameError;
import com.google.gxp.compiler.codegen.IllegalOperatorError;
import com.google.gxp.compiler.codegen.MissingExpressionError;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class OutputLanguageUtil {
    private final ImmutableSet<String> reservedWords;
    private final ImmutableSet<String> forbiddenOps;
    private final Pattern opsFinder;
    private final CharEscaper expressionEscaper;
    private final CharEscaper stringEscaper;
    private static final Pattern TRICKY_JAVA_TOKEN = Pattern.compile("('(?:[^\\n'\\\\]|\\\\.)*(')?)|(\"(?:[^\\n\"\\\\]|\\\\.)*(\")?)|(/\\*(?:[^*]|\\*+[^/*])*(\\*/)?)|(//[^\\n]*(\\n)?)", 32);
    private static final Map<Character, Character> NESTING_PAIRS = ImmutableMap.builder().put(Character.valueOf('('), Character.valueOf(')')).put(Character.valueOf('['), Character.valueOf(']')).put(Character.valueOf('{'), Character.valueOf('}')).build();
    private static final Collection<Character> NESTING_OPENINGS = NESTING_PAIRS.keySet();
    private static final Collection<Character> NESTING_CLOSINGS = NESTING_PAIRS.values();

    protected OutputLanguageUtil(Iterable<String> reservedWords, Iterable<String> forbiddenOps, Pattern opsFinder, CharEscaper expressionEscaper, CharEscaper stringEscaper) {
        this.reservedWords = ImmutableSet.copyOf(reservedWords);
        this.forbiddenOps = ImmutableSet.copyOf(forbiddenOps);
        this.opsFinder = Preconditions.checkNotNull(opsFinder);
        this.expressionEscaper = Preconditions.checkNotNull(expressionEscaper);
        this.stringEscaper = Preconditions.checkNotNull(stringEscaper);
    }

    public String validateExpression(AlertSink alertSink, NativeExpression expr, OutputLanguage outputLanguage) {
        String result = expr.getNativeCode(outputLanguage);
        if (result == null) {
            alertSink.add(new MissingExpressionError(expr, outputLanguage));
            return "";
        }
        String s = this.removeCommentsAndLiterals(alertSink, expr, outputLanguage);
        Character c = this.findMismatches(s);
        if (c != null) {
            alertSink.add(new IllegalExpressionError(expr, outputLanguage));
        }
        Matcher m = this.opsFinder.matcher(s);
        while (m.find()) {
            if (!this.forbiddenOps.contains(m.group())) continue;
            alertSink.add(new IllegalOperatorError(expr, outputLanguage, m.group()));
        }
        return this.expressionEscaper.escape(result);
    }

    private String removeCommentsAndLiterals(AlertSink alertSink, NativeExpression expr, OutputLanguage outputLanguage) {
        String str = expr.getNativeCode(outputLanguage);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        Matcher m = TRICKY_JAVA_TOKEN.matcher(str);
        while (m.find()) {
            sb.append(str.substring(start, m.start()));
            start = m.end();
            if (m.group(1) != null) {
                sb.append("'x'");
                if (m.group(2) != null) continue;
                alertSink.add(new IllegalExpressionError(expr, outputLanguage));
                continue;
            }
            if (m.group(3) != null) {
                sb.append("\"\"");
                if (m.group(4) != null) continue;
                alertSink.add(new IllegalExpressionError(expr, outputLanguage));
                continue;
            }
            if (m.group(5) != null && m.group(6) == null) {
                alertSink.add(new IllegalExpressionError(expr, outputLanguage));
                continue;
            }
            if (m.group(7) == null || m.group(8) != null) continue;
            alertSink.add(new IllegalExpressionError(expr, outputLanguage));
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    private Character findMismatches(String s) {
        ArrayDeque<Character> state = new ArrayDeque<Character>();
        char[] arr$ = s.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (NESTING_OPENINGS.contains(c)) {
                state.push(NESTING_PAIRS.get(c));
                continue;
            }
            if (!NESTING_CLOSINGS.contains(c)) continue;
            if (state.isEmpty() || !((Character)state.peek()).equals(c)) {
                return c;
            }
            state.pop();
        }
        if (!state.isEmpty()) {
            return (Character)state.pop();
        }
        return null;
    }

    protected static Pattern compileUnionPattern(String ... patterns) {
        return Pattern.compile(Join.join("|", patterns));
    }

    public String validateName(AlertSink alertSink, Node node, String name, OutputLanguage outputLanguage) {
        if (this.reservedWords.contains(name)) {
            alertSink.add(new IllegalNameError(node, outputLanguage, name));
        }
        return name;
    }

    public String toStringLiteral(String s) {
        return '\"' + this.stringEscaper.escape(s) + '\"';
    }
}

