/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import com.google.gxp.com.google.common.io.Closeables;
import com.google.gxp.com.google.common.io.IoSupplier;
import com.google.gxp.com.google.common.io.LineReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class Characters {
    private static final int BUF_SIZE = 2048;

    private Characters() {
    }

    public static IoSupplier<StringReader> newReaderSupplier(final String value) {
        return new IoSupplier<StringReader>(){

            @Override
            public StringReader get() {
                return new StringReader(value);
            }
        };
    }

    public static IoSupplier<InputStreamReader> newReaderSupplier(final IoSupplier<? extends InputStream> in, final Charset charset) {
        return new IoSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader get() throws IOException {
                return new InputStreamReader((InputStream)in.get(), charset);
            }
        };
    }

    public static IoSupplier<OutputStreamWriter> newWriterSupplier(final IoSupplier<? extends OutputStream> out, final Charset charset) {
        return new IoSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter get() throws IOException {
                return new OutputStreamWriter((OutputStream)out.get(), charset);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable, W extends Appendable & Closeable> long copy(IoSupplier<R> from, IoSupplier<W> to) throws IOException {
        boolean threw = true;
        Readable in = (Readable)from.get();
        try {
            long l;
            Appendable out = (Appendable)to.get();
            try {
                long count = Characters.copy(in, out);
                threw = false;
                l = count;
            }
            catch (Throwable throwable) {
                Closeables.close((Closeable)((Object)out), threw);
                throw throwable;
            }
            Closeables.close((Closeable)((Object)out), threw);
            return l;
        }
        finally {
            Closeables.close((Closeable)((Object)in), threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> long copy(IoSupplier<R> from, Appendable to) throws IOException {
        boolean threw = true;
        Readable in = (Readable)from.get();
        try {
            long count = Characters.copy(in, to);
            threw = false;
            long l = count;
            return l;
        }
        finally {
            Closeables.close((Closeable)((Object)in), threw);
        }
    }

    public static long copy(Readable from, Appendable to) throws IOException {
        int r;
        CharBuffer buf = CharBuffer.allocate(2048);
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            buf.flip();
            to.append(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        return Characters.toStringBuilder(r).toString();
    }

    public static <R extends Readable & Closeable> String toString(IoSupplier<R> supplier) throws IOException {
        return Characters.toStringBuilder(supplier).toString();
    }

    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        StringBuilder sb = new StringBuilder();
        Characters.copy(r, (Appendable)sb);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends Readable & Closeable> StringBuilder toStringBuilder(IoSupplier<R> supplier) throws IOException {
        boolean threw = true;
        Readable r = (Readable)supplier.get();
        try {
            StringBuilder result = Characters.toStringBuilder(r);
            threw = false;
            StringBuilder stringBuilder = result;
            return stringBuilder;
        }
        finally {
            Closeables.close((Closeable)((Object)r), threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> String readFirstLine(IoSupplier<R> supplier) throws IOException {
        boolean threw = true;
        Readable r = (Readable)supplier.get();
        try {
            String line = new LineReader(r).readLine();
            threw = false;
            String string = line;
            return string;
        }
        finally {
            Closeables.close((Closeable)((Object)r), threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> List<String> readLines(IoSupplier<R> supplier) throws IOException {
        boolean threw = true;
        Readable r = (Readable)supplier.get();
        try {
            List<String> result = Characters.readLines(r);
            threw = false;
            List<String> list = result;
            return list;
        }
        finally {
            Closeables.close((Closeable)((Object)r), threw);
        }
    }

    public static List<String> readLines(Readable r) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineReader lineReader = new LineReader(r);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }
}

