/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.CustomFieldSerializer;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializedTypeViolationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamReader;
import com.google.gwt.user.server.Base64Utils;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.ServerCustomFieldSerializer;
import com.google.gwt.user.server.rpc.impl.DequeMap;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class ServerSerializationStreamReader
extends AbstractSerializationStreamReader {
    private static final Pattern ALLOWED_STRONG_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    private static final Map<Class<?>, ValueReader> CLASS_TO_VALUE_READER = new IdentityHashMap();
    private static final Map<Class<?>, VectorReader> CLASS_TO_VECTOR_READER = new IdentityHashMap();
    private final ClassLoader classLoader;
    private SerializationPolicy serializationPolicy = RPC.getDefaultSerializationPolicy();
    private final SerializationPolicyProvider serializationPolicyProvider;
    private final Map<Class<?>, Map<String, Method>> settersByClass = new HashMap();
    private String[] stringTable;
    private final ArrayList<String> tokenList = new ArrayList();
    private int tokenListIndex;

    public ServerSerializationStreamReader(ClassLoader classLoader, SerializationPolicyProvider serializationPolicyProvider) {
        CLASS_TO_VECTOR_READER.put(boolean[].class, VectorReader.BOOLEAN_VECTOR);
        CLASS_TO_VECTOR_READER.put(byte[].class, VectorReader.BYTE_VECTOR);
        CLASS_TO_VECTOR_READER.put(char[].class, VectorReader.CHAR_VECTOR);
        CLASS_TO_VECTOR_READER.put(double[].class, VectorReader.DOUBLE_VECTOR);
        CLASS_TO_VECTOR_READER.put(float[].class, VectorReader.FLOAT_VECTOR);
        CLASS_TO_VECTOR_READER.put(int[].class, VectorReader.INT_VECTOR);
        CLASS_TO_VECTOR_READER.put(long[].class, VectorReader.LONG_VECTOR);
        CLASS_TO_VECTOR_READER.put(Object[].class, VectorReader.OBJECT_VECTOR);
        CLASS_TO_VECTOR_READER.put(short[].class, VectorReader.SHORT_VECTOR);
        CLASS_TO_VECTOR_READER.put(String[].class, VectorReader.STRING_VECTOR);
        CLASS_TO_VALUE_READER.put(Boolean.TYPE, ValueReader.BOOLEAN);
        CLASS_TO_VALUE_READER.put(Byte.TYPE, ValueReader.BYTE);
        CLASS_TO_VALUE_READER.put(Character.TYPE, ValueReader.CHAR);
        CLASS_TO_VALUE_READER.put(Double.TYPE, ValueReader.DOUBLE);
        CLASS_TO_VALUE_READER.put(Float.TYPE, ValueReader.FLOAT);
        CLASS_TO_VALUE_READER.put(Integer.TYPE, ValueReader.INT);
        CLASS_TO_VALUE_READER.put(Long.TYPE, ValueReader.LONG);
        CLASS_TO_VALUE_READER.put(Object.class, ValueReader.OBJECT);
        CLASS_TO_VALUE_READER.put(Short.TYPE, ValueReader.SHORT);
        CLASS_TO_VALUE_READER.put(String.class, ValueReader.STRING);
        this.classLoader = classLoader;
        this.serializationPolicyProvider = serializationPolicyProvider;
    }

    public Object deserializeValue(Class<?> rpcType) throws SerializationException {
        ValueReader valueReader = CLASS_TO_VALUE_READER.get(rpcType);
        if (valueReader != null) {
            return valueReader.readValue(this);
        }
        return ValueReader.OBJECT.readValue(this);
    }

    public Object deserializeValue(Class<?> rpcType, Type methodType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
        ValueReader valueReader = CLASS_TO_VALUE_READER.get(rpcType);
        if (valueReader != null) {
            return valueReader.readValue(this, methodType, resolvedTypes);
        }
        return ValueReader.OBJECT.readValue(this, methodType, resolvedTypes);
    }

    public int getNumberOfTokens() {
        return this.tokenList.size();
    }

    public SerializationPolicy getSerializationPolicy() {
        return this.serializationPolicy;
    }

    @Override
    public void prepareToRead(String encodedTokens) throws SerializationException {
        int nextIdx;
        this.tokenList.clear();
        this.tokenListIndex = 0;
        this.stringTable = null;
        int idx = 0;
        while (-1 != (nextIdx = encodedTokens.indexOf(124, idx))) {
            String current = encodedTokens.substring(idx, nextIdx);
            this.tokenList.add(current);
            idx = nextIdx + 1;
        }
        if (idx == 0) {
            while (idx < encodedTokens.length() && Character.isDigit(encodedTokens.charAt(idx))) {
                ++idx;
            }
            if (idx == 0) {
                throw new IncompatibleRemoteServiceException("Malformed or old RPC message received - expecting version between 5 and 8");
            }
            int version = Integer.valueOf(encodedTokens.substring(0, idx));
            throw new IncompatibleRemoteServiceException("Expecting version between 5 and 8 from client, got " + version + ".");
        }
        super.prepareToRead(encodedTokens);
        if (this.getVersion() < 5 || this.getVersion() > 8) {
            throw new IncompatibleRemoteServiceException("Expecting version between 5 and 8 from client, got " + this.getVersion() + ".");
        }
        if (!this.areFlagsValid()) {
            throw new IncompatibleRemoteServiceException("Got an unknown flag from client: " + this.getFlags());
        }
        this.deserializeStringTable();
        String moduleBaseURL = this.readString();
        String strongName = this.readString();
        if (this.serializationPolicyProvider != null) {
            if (strongName != null && !ALLOWED_STRONG_NAME.matcher(strongName).matches()) {
                throw new SerializationException("GWT-RPC request is invalid because the strong name contains invalid characters");
            }
            this.serializationPolicy = this.serializationPolicyProvider.getSerializationPolicy(moduleBaseURL, strongName);
            if (this.serializationPolicy == null) {
                throw new NullPointerException("serializationPolicyProvider.getSerializationPolicy()");
            }
        }
    }

    @Override
    public boolean readBoolean() throws SerializationException {
        return !this.extract().equals("0");
    }

    @Override
    public byte readByte() throws SerializationException {
        String value = this.extract();
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw this.getNumberFormatException(value, "byte", -128.0, 127.0);
        }
    }

    @Override
    public char readChar() throws SerializationException {
        return (char)this.readInt();
    }

    @Override
    public double readDouble() throws SerializationException {
        return Double.parseDouble(this.extract());
    }

    @Override
    public float readFloat() throws SerializationException {
        return (float)Double.parseDouble(this.extract());
    }

    @Override
    public int readInt() throws SerializationException {
        String value = this.extract();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.getNumberFormatException(value, "int", -2.147483648E9, 2.147483647E9);
        }
    }

    @Override
    public long readLong() throws SerializationException {
        if (this.getVersion() == 5) {
            return (long)this.readDouble() + (long)this.readDouble();
        }
        return Base64Utils.longFromBase64(this.extract());
    }

    public Object readObject(Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
        int token = this.readInt();
        if (token < 0) {
            return this.getDecodedObject(-token);
        }
        String typeSignature = this.getString(token);
        if (typeSignature == null) {
            return null;
        }
        if (this.isSimpleClass(expectedType) && !resolvedTypes.isEmpty()) {
            resolvedTypes = new DequeMap();
        }
        return this.deserialize(typeSignature, expectedType, resolvedTypes);
    }

    @Override
    public short readShort() throws SerializationException {
        String value = this.extract();
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw this.getNumberFormatException(value, "short", -32768.0, 32767.0);
        }
    }

    @Override
    public String readString() throws SerializationException {
        return this.getString(this.readInt());
    }

    @Override
    protected Object deserialize(String typeSignature) throws SerializationException {
        return this.deserialize(typeSignature, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserialize(String typeSignature, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
        Object instance = null;
        try {
            Class<?> instanceClass;
            if (this.hasFlags(1)) {
                if (!(this.getSerializationPolicy() instanceof TypeNameObfuscator)) throw new SerializationException("The GWT module was compiled with RPC type name elision enabled, but " + this.getSerializationPolicy().getClass().getName() + " does not implement " + TypeNameObfuscator.class.getName());
                TypeNameObfuscator obfuscator = (TypeNameObfuscator)((Object)this.getSerializationPolicy());
                String instanceClassName = obfuscator.getClassNameForTypeId(typeSignature);
                instanceClass = Class.forName(instanceClassName, false, this.classLoader);
            } else {
                SerializedInstanceReference serializedInstRef = SerializabilityUtil.decodeSerializedInstanceReference(typeSignature);
                instanceClass = Class.forName(serializedInstRef.getName(), false, this.classLoader);
                this.validateTypeVersions(instanceClass, serializedInstRef);
            }
            if (resolvedTypes == null) {
                resolvedTypes = new DequeMap();
            }
            TypeVariable<Class<?>>[] instanceParameterTypes = instanceClass.getTypeParameters();
            Type[] expectedParameterTypes = null;
            if (expectedType != null) {
                SerializabilityUtil.resolveTypes(expectedType, resolvedTypes);
                expectedParameterTypes = SerializabilityUtil.findExpectedParameterTypes(instanceClass, expectedType, resolvedTypes);
                if (expectedParameterTypes == null) {
                    throw new SerializedTypeViolationException("Attempt to deserialize an object of type " + instanceClass.toString() + " when an object of type " + SerializabilityUtil.findActualType(expectedType, resolvedTypes).toString() + " is expected");
                }
                for (int i = 0; i < instanceParameterTypes.length; ++i) {
                    resolvedTypes.add(instanceParameterTypes[i], expectedParameterTypes[i]);
                }
            }
            assert (this.serializationPolicy != null);
            this.serializationPolicy.validateDeserialize(instanceClass);
            Class<?> customSerializer = SerializabilityUtil.hasServerCustomFieldSerializer(instanceClass);
            int index = this.reserveDecodedObjectIndex();
            instance = this.instantiate(customSerializer, instanceClass, expectedParameterTypes, resolvedTypes);
            this.rememberDecodedObject(index, instance);
            Object replacement = this.deserializeImpl(customSerializer, instanceClass, instance, expectedType, expectedParameterTypes, resolvedTypes);
            if (expectedParameterTypes != null) {
                for (int i = 0; i < instanceParameterTypes.length; ++i) {
                    resolvedTypes.remove(instanceParameterTypes[i]);
                }
            }
            SerializabilityUtil.releaseTypes(expectedType, resolvedTypes);
            if (instance == replacement) return instance;
            this.rememberDecodedObject(index, replacement);
            return replacement;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
        catch (InstantiationException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    protected String getString(int index) {
        if (index == 0) {
            return null;
        }
        assert (index > 0);
        assert (index <= this.stringTable.length);
        return this.stringTable[index - 1];
    }

    private Object deserializeArray(Class<?> instanceClass, Object instance) throws SerializationException {
        assert (instanceClass.isArray());
        BoundedList buffer = (BoundedList)instance;
        VectorReader instanceReader = CLASS_TO_VECTOR_READER.get(instanceClass);
        if (instanceReader != null) {
            return instanceReader.read(this, buffer);
        }
        return VectorReader.OBJECT_VECTOR.read(this, buffer);
    }

    private Object deserializeArray(Class<?> instanceClass, Object instance, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
        assert (instanceClass.isArray());
        BoundedList buffer = (BoundedList)instance;
        VectorReader instanceReader = CLASS_TO_VECTOR_READER.get(instanceClass);
        if (instanceReader != null) {
            return instanceReader.read(this, buffer, expectedType, resolvedTypes);
        }
        return VectorReader.OBJECT_VECTOR.read(this, buffer, expectedType, resolvedTypes);
    }

    private void deserializeClass(Class<?> instanceClass, Object instance, Type expectedType, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Field[] serializableFields;
        Map<String, Method> setters = null;
        Set<String> clientFieldNames = this.serializationPolicy.getClientFieldNamesForEnhancedClass(instanceClass);
        if (clientFieldNames != null) {
            try {
                String encodedData = this.readString();
                if (encodedData != null) {
                    byte[] byArray = Base64Utils.fromBase64(encodedData);
                    ByteArrayInputStream baos = new ByteArrayInputStream(byArray);
                    ObjectInputStream ois = new ObjectInputStream(baos);
                    int count = ois.readInt();
                    for (int i = 0; i < count; ++i) {
                        String fieldName = (String)ois.readObject();
                        Object fieldValue = ois.readObject();
                        Field field = instanceClass.getDeclaredField(fieldName);
                        field.setAccessible(true);
                        field.set(instance, fieldValue);
                    }
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
            catch (NoSuchFieldException e) {
                throw new SerializationException(e);
            }
            setters = this.getSetters(instanceClass);
        }
        for (Field declField : serializableFields = SerializabilityUtil.applyFieldSerializationPolicy(instanceClass, this.serializationPolicy)) {
            boolean needsAccessOverride;
            Method setter;
            assert (declField != null);
            if (clientFieldNames != null && !clientFieldNames.contains(declField.getName())) continue;
            Type declGenericType = declField.getGenericType();
            Object value = this.deserializeValue(declField.getType(), declGenericType, resolvedTypes);
            String fieldName = declField.getName();
            if (setters != null && (setter = setters.get(fieldName)) != null) {
                setter.invoke(instance, value);
                continue;
            }
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers()) || Modifier.isFinal(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            declField.set(instance, value);
        }
        Class<?> clazz = instanceClass.getSuperclass();
        if (this.serializationPolicy.shouldDeserializeFields(clazz)) {
            Type[] superParameterTypes = SerializabilityUtil.findExpectedParameterTypes(clazz, clazz, resolvedTypes);
            this.deserializeImpl(SerializabilityUtil.hasServerCustomFieldSerializer(clazz), clazz, instance, expectedType, superParameterTypes, resolvedTypes);
        }
    }

    private Object deserializeImpl(Class<?> customSerializer, Class<?> instanceClass, Object instance, Type expectedType, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException, ClassNotFoundException {
        if (customSerializer != null) {
            CustomFieldSerializer<?> customFieldSerializer = SerializabilityUtil.loadCustomFieldSerializer(customSerializer);
            if (customFieldSerializer == null) {
                this.deserializeWithCustomFieldDeserializer(customSerializer, instanceClass, instance, expectedParameterTypes, resolvedTypes);
            } else if (customFieldSerializer instanceof ServerCustomFieldSerializer && expectedParameterTypes != null) {
                ServerCustomFieldSerializer serverCFS = (ServerCustomFieldSerializer)customFieldSerializer;
                serverCFS.deserializeInstance(this, instance, expectedParameterTypes, resolvedTypes);
            } else {
                customFieldSerializer.deserializeInstance(this, instance);
            }
        } else if (instanceClass.isArray()) {
            if (expectedType == null) {
                return this.deserializeArray(instanceClass, instance);
            }
            Type actualExpectedType = SerializabilityUtil.findActualType(expectedType, resolvedTypes);
            if (actualExpectedType instanceof GenericArrayType) {
                Type arrayType = ((GenericArrayType)actualExpectedType).getGenericComponentType();
                return this.deserializeArray(instanceClass, instance, arrayType, resolvedTypes);
            }
            if (((Class)actualExpectedType).getComponentType() != null) {
                Class<?> arrayType = ((Class)actualExpectedType).getComponentType();
                return this.deserializeArray(instanceClass, instance, arrayType, resolvedTypes);
            }
        } else if (!instanceClass.isEnum()) {
            this.deserializeClass(instanceClass, instance, expectedType, expectedParameterTypes, resolvedTypes);
        }
        return instance;
    }

    private void deserializeStringTable() throws SerializationException {
        int typeNameCount = this.readInt();
        BoundedList<String> buffer = new BoundedList<String>(String.class, typeNameCount);
        for (int typeNameIndex = 0; typeNameIndex < typeNameCount; ++typeNameIndex) {
            String str = this.extract();
            int idx = str.indexOf(92);
            if (idx >= 0) {
                StringBuilder buf = new StringBuilder();
                int pos = 0;
                while (idx >= 0) {
                    buf.append(str.substring(pos, idx));
                    if (++idx == str.length()) {
                        throw new SerializationException("Unmatched backslash: \"" + str + "\"");
                    }
                    char ch = str.charAt(idx);
                    pos = idx + 1;
                    switch (ch) {
                        case '0': {
                            buf.append('\u0000');
                            break;
                        }
                        case '!': {
                            buf.append('|');
                            break;
                        }
                        case '\\': {
                            buf.append(ch);
                            break;
                        }
                        case 'u': {
                            try {
                                ch = (char)Integer.parseInt(str.substring(idx + 1, idx + 5), 16);
                            }
                            catch (NumberFormatException e) {
                                throw new SerializationException("Invalid Unicode escape sequence in \"" + str + "\"");
                            }
                            buf.append(ch);
                            pos += 4;
                            break;
                        }
                        default: {
                            throw new SerializationException("Unexpected escape character " + ch + " after backslash: \"" + str + "\"");
                        }
                    }
                    idx = str.indexOf(92, pos);
                }
                buf.append(str.substring(pos));
                str = buf.toString();
            }
            buffer.add(str);
        }
        if (buffer.size() != buffer.getExpectedSize()) {
            throw new SerializationException("Expected " + buffer.getExpectedSize() + " string table elements; received " + buffer.size());
        }
        this.stringTable = buffer.toArray(new String[buffer.getExpectedSize()]);
    }

    private void deserializeWithCustomFieldDeserializer(Class<?> customSerializer, Class<?> instanceClass, Object instance, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        assert (!instanceClass.isArray());
        if (expectedParameterTypes != null) {
            for (Method method : customSerializer.getMethods()) {
                if (!"deserializeChecked".equals(method.getName())) continue;
                method.invoke(null, this, instance, expectedParameterTypes, resolvedTypes);
                return;
            }
        }
        for (Method method : customSerializer.getMethods()) {
            if (!"deserialize".equals(method.getName())) continue;
            method.invoke(null, this, instance);
            return;
        }
        throw new NoSuchMethodException("deserialize");
    }

    private String extract() throws SerializationException {
        try {
            return this.tokenList.get(this.tokenListIndex++);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SerializationException("Too few tokens in RPC request", e);
        }
    }

    private NumberFormatException getNumberFormatException(String value, String type, double minValue, double maxValue) {
        String message = "a non-numerical value";
        try {
            double d = Double.parseDouble(value);
            if (d < minValue || d > maxValue) {
                message = "an out-of-range value";
            } else if (d != Math.floor(d)) {
                message = "a fractional value";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new NumberFormatException("Expected type '" + type + "' but received " + message + ": " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Method> getSetters(Class<?> instanceClass) {
        Map<Class<?>, Map<String, Method>> map = this.settersByClass;
        synchronized (map) {
            Map<String, Method> setters = this.settersByClass.get(instanceClass);
            if (setters == null) {
                Field[] fields;
                setters = new HashMap<String, Method>();
                for (Field field : fields = instanceClass.getDeclaredFields()) {
                    if (!SerializabilityUtil.isNotStaticOrTransient(field) || !SerializabilityUtil.isNotFinal(field)) continue;
                    String fieldName = field.getName();
                    String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                    try {
                        Method setter = instanceClass.getMethod(setterName, field.getType());
                        setters.put(fieldName, setter);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                this.settersByClass.put(instanceClass, setters);
            }
            return setters;
        }
    }

    private Object instantiate(Class<?> customSerializer, Class<?> instanceClass, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SerializationException {
        if (customSerializer != null) {
            CustomFieldSerializer<?> customFieldSerializer = SerializabilityUtil.loadCustomFieldSerializer(customSerializer);
            if (customFieldSerializer == null) {
                Object result = this.instantiateWithCustomFieldInstantiator(customSerializer, expectedParameterTypes, resolvedTypes);
                if (result != null) {
                    return result;
                }
            } else if (customFieldSerializer.hasCustomInstantiateInstance()) {
                if (expectedParameterTypes != null && customFieldSerializer instanceof ServerCustomFieldSerializer) {
                    ServerCustomFieldSerializer serverCFS = (ServerCustomFieldSerializer)customFieldSerializer;
                    return serverCFS.instantiateInstance(this, expectedParameterTypes, resolvedTypes);
                }
                return customFieldSerializer.instantiateInstance(this);
            }
        }
        if (instanceClass.isArray()) {
            int length = this.readInt();
            return new BoundedList(instanceClass.getComponentType(), length);
        }
        if (instanceClass.isEnum()) {
            Enum[] enumConstants = (Enum[])instanceClass.getEnumConstants();
            int ordinal = this.readInt();
            assert (ordinal >= 0 && ordinal < enumConstants.length);
            return enumConstants[ordinal];
        }
        Constructor<?> constructor = instanceClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private Object instantiateWithCustomFieldInstantiator(Class<?> customSerializer, Type[] expectedParameterTypes, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (expectedParameterTypes != null) {
            for (Method method : customSerializer.getMethods()) {
                if (!"instantiateChecked".equals(method.getName())) continue;
                return method.invoke(null, this, expectedParameterTypes, resolvedTypes);
            }
        }
        for (Method method : customSerializer.getMethods()) {
            if (!"instantiate".equals(method.getName())) continue;
            return method.invoke(null, this);
        }
        return null;
    }

    private boolean isSimpleClass(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class cl = (Class)t;
        return cl.getTypeParameters().length == 0 && cl.getEnclosingClass() == null;
    }

    private void validateTypeVersions(Class<?> instanceClass, SerializedInstanceReference serializedInstRef) throws SerializationException {
        String clientTypeSignature = serializedInstRef.getSignature();
        if (clientTypeSignature.length() == 0) {
            throw new SerializationException("Missing type signature for " + instanceClass.getName());
        }
        String serverTypeSignature = SerializabilityUtil.getSerializationSignature(instanceClass, this.serializationPolicy);
        if (!clientTypeSignature.equals(serverTypeSignature)) {
            throw new SerializationException("Invalid type signature for " + instanceClass.getName());
        }
    }

    private static enum VectorReader {
        BOOLEAN_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readBoolean();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setBoolean(array, index, (Boolean)value);
            }
        }
        ,
        BYTE_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readByte();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setByte(array, index, (Byte)value);
            }
        }
        ,
        CHAR_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Character.valueOf(stream.readChar());
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setChar(array, index, ((Character)value).charValue());
            }
        }
        ,
        DOUBLE_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readDouble();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setDouble(array, index, (Double)value);
            }
        }
        ,
        FLOAT_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Float.valueOf(stream.readFloat());
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setFloat(array, index, ((Float)value).floatValue());
            }
        }
        ,
        INT_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readInt();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setInt(array, index, (Integer)value);
            }
        }
        ,
        LONG_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readLong();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setLong(array, index, (Long)value);
            }
        }
        ,
        OBJECT_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readObject();
            }

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
                return stream.readObject(expectedType, resolvedTypes);
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.set(array, index, value);
            }
        }
        ,
        SHORT_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readShort();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.setShort(array, index, (Short)value);
            }
        }
        ,
        STRING_VECTOR{

            @Override
            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readString();
            }

            @Override
            protected void setSingleValue(Object array, int index, Object value) {
                Array.set(array, index, value);
            }
        };


        protected abstract Object readSingleValue(ServerSerializationStreamReader var1) throws SerializationException;

        protected Object readSingleValue(ServerSerializationStreamReader stream, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
            return this.readSingleValue(stream);
        }

        protected abstract void setSingleValue(Object var1, int var2, Object var3);

        protected Object toArray(Class<?> componentType, BoundedList<Object> buffer) throws SerializationException {
            if (buffer.getExpectedSize() != buffer.size()) {
                throw new SerializationException("Inconsistent number of elements received. Received " + buffer.size() + " but expecting " + buffer.getExpectedSize());
            }
            Object arr = Array.newInstance(componentType, buffer.size());
            int n = buffer.size();
            for (int i = 0; i < n; ++i) {
                this.setSingleValue(arr, i, buffer.removeFirst());
            }
            return arr;
        }

        Object read(ServerSerializationStreamReader stream, BoundedList<Object> instance) throws SerializationException {
            int n = instance.getExpectedSize();
            for (int i = 0; i < n; ++i) {
                instance.add(this.readSingleValue(stream));
            }
            return this.toArray(instance.getComponentType(), instance);
        }

        Object read(ServerSerializationStreamReader stream, BoundedList<Object> instance, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
            int n = instance.getExpectedSize();
            for (int i = 0; i < n; ++i) {
                instance.add(this.readSingleValue(stream, expectedType, resolvedTypes));
            }
            return this.toArray(instance.getComponentType(), instance);
        }
    }

    private static enum ValueReader {
        BOOLEAN{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readBoolean();
            }
        }
        ,
        BYTE{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readByte();
            }
        }
        ,
        CHAR{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Character.valueOf(stream.readChar());
            }
        }
        ,
        DOUBLE{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readDouble();
            }
        }
        ,
        FLOAT{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Float.valueOf(stream.readFloat());
            }
        }
        ,
        INT{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readInt();
            }
        }
        ,
        LONG{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readLong();
            }
        }
        ,
        OBJECT{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readObject();
            }

            @Override
            Object readValue(ServerSerializationStreamReader stream, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
                return stream.readObject(expectedType, resolvedTypes);
            }
        }
        ,
        SHORT{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readShort();
            }
        }
        ,
        STRING{

            @Override
            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readString();
            }
        };


        abstract Object readValue(ServerSerializationStreamReader var1) throws SerializationException;

        Object readValue(ServerSerializationStreamReader stream, Type expectedType, DequeMap<TypeVariable<?>, Type> resolvedTypes) throws SerializationException {
            return this.readValue(stream);
        }
    }

    private static class BoundedList<T>
    extends LinkedList<T> {
        private final Class<?> componentType;
        private final int expectedSize;

        public BoundedList(Class<?> componentType, int expectedSize) {
            this.componentType = componentType;
            this.expectedSize = expectedSize;
        }

        @Override
        public boolean add(T o) {
            assert (this.size() < this.getExpectedSize());
            return super.add(o);
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }

        public int getExpectedSize() {
            return this.expectedSize;
        }
    }
}

