/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import com.google.gwt.logging.server.InvalidJsonLogRecordFormatException;
import com.google.gwt.thirdparty.json.JSONArray;
import com.google.gwt.thirdparty.json.JSONException;
import com.google.gwt.thirdparty.json.JSONObject;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JsonLogRecordServerUtil {
    public static LogRecord logRecordFromJson(String jsonString) throws InvalidJsonLogRecordFormatException {
        try {
            JSONObject lro = new JSONObject(jsonString);
            String level = lro.getString("level");
            String loggerName = lro.getString("loggerName");
            String msg = lro.getString("msg");
            long timestamp = Long.parseLong(lro.getString("timestamp"));
            Throwable thrown = JsonLogRecordThrowable.fromJsonString(lro.getString("thrown"));
            LogRecord lr = new LogRecord(Level.parse(level), msg);
            lr.setLoggerName(loggerName);
            lr.setThrown(thrown);
            lr.setMillis(timestamp);
            return lr;
        }
        catch (JSONException e) {
            throw new InvalidJsonLogRecordFormatException(e);
        }
    }

    private static class JsonLogRecordThrowable
    extends Throwable {
        private String type;

        private static Throwable fromJsonString(String jsonString) throws JSONException {
            if (jsonString.equals("{}")) {
                return null;
            }
            return new JsonLogRecordThrowable(new JSONObject(jsonString));
        }

        public JsonLogRecordThrowable(JSONObject t) throws JSONException {
            super(t.getString("message"));
            this.type = t.getString("type");
            this.setStackTrace(this.stackTraceFromJson(t.optJSONArray("stackTrace")));
            this.initCause(JsonLogRecordThrowable.fromJsonString(t.getString("cause")));
        }

        private StackTraceElement[] stackTraceFromJson(JSONArray st) throws JSONException {
            if (st == null || st.length() <= 0) {
                return new StackTraceElement[0];
            }
            StackTraceElement[] stackTrace = new StackTraceElement[st.length()];
            for (int i = 0; i < st.length(); ++i) {
                stackTrace[i] = this.stackTraceElementFromJson(st.getString(i));
            }
            return stackTrace;
        }

        private StackTraceElement stackTraceElementFromJson(String jsonString) throws JSONException {
            JSONObject ste = new JSONObject(jsonString);
            String className = ste.getString("className");
            String fileName = ste.getString("fileName");
            String methodName = ste.getString("methodName");
            int lineNumber = Integer.parseInt(ste.getString("lineNumber"));
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }

        @Override
        public String toString() {
            String string;
            if (this.getMessage() != null) {
                String string2 = this.type;
                String string3 = String.valueOf(this.getMessage());
                string = new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(": ").append(string3).toString();
            } else {
                string = this.type;
            }
            return string;
        }
    }
}

