/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.ImageBundle;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBar
extends Widget
implements PopupListener,
HasAnimation,
HasCloseHandlers<PopupPanel> {
    private static final String STYLENAME_DEFAULT = "gwt-MenuBar";
    private ArrayList<UIObject> allItems = new ArrayList();
    private ArrayList<MenuItem> items = new ArrayList();
    private Element body;
    private MenuBarImages images = null;
    private boolean isAnimationEnabled = false;
    private MenuBar parentMenu;
    private PopupPanel popup;
    private MenuItem selectedItem;
    private MenuBar shownChildMenu;
    private boolean vertical;
    private boolean autoOpen;

    public MenuBar() {
        this(false);
    }

    public MenuBar(boolean vertical) {
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            this.init(vertical, (MenuBarImages)GWT.create(MenuBarImagesRTL.class));
        } else {
            this.init(vertical, (MenuBarImages)GWT.create(MenuBarImages.class));
        }
    }

    public MenuBar(boolean vertical, MenuBarImages images) {
        this.init(vertical, images);
    }

    public MenuBar(MenuBarImages images) {
        this(false, images);
    }

    @Override
    public HandlerRegistration addCloseHandler(CloseHandler<PopupPanel> handler) {
        return super.addHandler(handler, CloseEvent.getType());
    }

    public MenuItem addItem(MenuItem item) {
        return this.insertItem(item, this.allItems.size());
    }

    public MenuItem addItem(String text, boolean asHTML, Command cmd) {
        return this.addItem(new MenuItem(text, asHTML, cmd));
    }

    public MenuItem addItem(String text, boolean asHTML, MenuBar popup) {
        return this.addItem(new MenuItem(text, asHTML, popup));
    }

    public MenuItem addItem(String text, Command cmd) {
        return this.addItem(new MenuItem(text, cmd));
    }

    public MenuItem addItem(String text, MenuBar popup) {
        return this.addItem(new MenuItem(text, popup));
    }

    public MenuItemSeparator addSeparator() {
        return this.addSeparator(new MenuItemSeparator());
    }

    public MenuItemSeparator addSeparator(MenuItemSeparator separator) {
        return this.insertSeparator(separator, this.allItems.size());
    }

    public void clearItems() {
        this.selectItem(null);
        Element container = this.getItemContainerElement();
        while (DOM.getChildCount(container) > 0) {
            DOM.removeChild(container, DOM.getChild(container, 0));
        }
        for (UIObject item : this.allItems) {
            this.setItemColSpan(item, 1);
            if (item instanceof MenuItemSeparator) {
                ((MenuItemSeparator)item).setParentMenu(null);
                continue;
            }
            ((MenuItem)item).setParentMenu(null);
        }
        this.items.clear();
        this.allItems.clear();
    }

    public boolean getAutoOpen() {
        return this.autoOpen;
    }

    public int getItemIndex(MenuItem item) {
        return this.allItems.indexOf(item);
    }

    public int getSeparatorIndex(MenuItemSeparator item) {
        return this.allItems.indexOf(item);
    }

    public MenuItem insertItem(MenuItem item, int beforeIndex) throws IndexOutOfBoundsException {
        if (beforeIndex < 0 || beforeIndex > this.allItems.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.allItems.add(beforeIndex, item);
        int itemsIndex = 0;
        for (int i = 0; i < beforeIndex; ++i) {
            if (!(this.allItems.get(i) instanceof MenuItem)) continue;
            ++itemsIndex;
        }
        this.items.add(itemsIndex, item);
        this.addItemElement(beforeIndex, item.getElement());
        item.setParentMenu(this);
        item.setSelectionStyle(false);
        this.updateSubmenuIcon(item);
        return item;
    }

    public MenuItemSeparator insertSeparator(int beforeIndex) {
        return this.insertSeparator(new MenuItemSeparator(), beforeIndex);
    }

    public MenuItemSeparator insertSeparator(MenuItemSeparator separator, int beforeIndex) throws IndexOutOfBoundsException {
        if (beforeIndex < 0 || beforeIndex > this.allItems.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.vertical) {
            this.setItemColSpan(separator, 2);
        }
        this.addItemElement(beforeIndex, separator.getElement());
        separator.setParentMenu(this);
        this.allItems.add(beforeIndex, separator);
        return separator;
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        MenuItem item = this.findItem(DOM.eventGetTarget(event));
        switch (DOM.eventGetType(event)) {
            case 1: {
                FocusPanel.impl.focus(this.getElement());
                if (item == null) break;
                this.doItemAction(item, true);
                break;
            }
            case 16: {
                if (item == null) break;
                this.itemOver(item, true);
                break;
            }
            case 32: {
                if (item == null) break;
                this.itemOver(null, true);
                break;
            }
            case 2048: {
                this.selectFirstItemIfNoneSelected();
                break;
            }
            case 128: {
                int keyCode = DOM.eventGetKeyCode(event);
                switch (keyCode) {
                    case 37: {
                        if (LocaleInfo.getCurrentLocale().isRTL()) {
                            this.moveToNextItem();
                        } else {
                            this.moveToPrevItem();
                        }
                        this.eatEvent(event);
                        break;
                    }
                    case 39: {
                        if (LocaleInfo.getCurrentLocale().isRTL()) {
                            this.moveToPrevItem();
                        } else {
                            this.moveToNextItem();
                        }
                        this.eatEvent(event);
                        break;
                    }
                    case 38: {
                        this.moveUp();
                        this.eatEvent(event);
                        break;
                    }
                    case 40: {
                        this.moveDown();
                        this.eatEvent(event);
                        break;
                    }
                    case 27: {
                        this.closeAllParents();
                        this.eatEvent(event);
                        break;
                    }
                    case 13: {
                        if (this.selectFirstItemIfNoneSelected()) break;
                        this.doItemAction(this.selectedItem, true);
                        this.eatEvent(event);
                    }
                }
                break;
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    @Deprecated
    public void onPopupClosed(PopupPanel sender, boolean autoClosed) {
        if (autoClosed) {
            this.closeAllParents();
        }
        this.onHide();
        CloseEvent.fire(this, sender);
        this.shownChildMenu = null;
        this.popup = null;
        if (this.parentMenu != null && this.parentMenu.popup != null) {
            this.parentMenu.popup.setPreviewingAllNativeEvents(true);
        }
    }

    public void removeItem(MenuItem item) {
        if (this.selectedItem == item) {
            this.selectItem(null);
        }
        if (this.removeItemElement(item)) {
            this.setItemColSpan(item, 1);
            this.items.remove(item);
            item.setParentMenu(null);
        }
    }

    public void removeSeparator(MenuItemSeparator separator) {
        if (this.removeItemElement(separator)) {
            separator.setParentMenu(null);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    protected List<MenuItem> getItems() {
        return this.items;
    }

    protected MenuItem getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    protected void onDetach() {
        if (this.popup != null) {
            this.popup.hide();
        }
        super.onDetach();
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.setMenuItemDebugIds(baseID);
    }

    void closeAllParents() {
        MenuBar curMenu = this;
        while (curMenu.parentMenu != null) {
            curMenu.close();
            curMenu = curMenu.parentMenu;
        }
    }

    void doItemAction(MenuItem item, boolean fireCommand) {
        this.selectItem(item);
        if (item != null) {
            if (fireCommand && item.getCommand() != null) {
                this.closeAllParents();
                Command cmd = item.getCommand();
                DeferredCommand.addCommand(cmd);
                if (this.shownChildMenu != null) {
                    this.shownChildMenu.onHide();
                    this.popup.hide();
                    this.shownChildMenu = null;
                    this.selectItem(null);
                }
            } else if (item.getSubMenu() != null) {
                if (this.shownChildMenu == null) {
                    this.openPopup(item);
                } else if (item.getSubMenu() != this.shownChildMenu) {
                    this.shownChildMenu.onHide();
                    this.popup.hide();
                    this.openPopup(item);
                } else if (fireCommand && !this.autoOpen) {
                    this.shownChildMenu.onHide();
                    this.popup.hide();
                    this.shownChildMenu = null;
                    this.selectItem(item);
                }
            } else if (this.autoOpen && this.shownChildMenu != null) {
                this.shownChildMenu.onHide();
                this.popup.hide();
                this.shownChildMenu = null;
            }
        }
    }

    void itemOver(MenuItem item, boolean focus) {
        if (item == null && this.selectedItem != null && this.shownChildMenu == this.selectedItem.getSubMenu()) {
            return;
        }
        this.selectItem(item);
        if (focus) {
            this.focus();
        }
        if (item != null && (this.shownChildMenu != null || this.parentMenu != null || this.autoOpen)) {
            this.doItemAction(item, false);
        }
    }

    void selectItem(MenuItem item) {
        Element td;
        Element tr;
        if (item == this.selectedItem) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.setSelectionStyle(false);
            if (this.vertical && DOM.getChildCount(tr = DOM.getParent(this.selectedItem.getElement())) == 2) {
                td = DOM.getChild(tr, 1);
                MenuBar.setStyleName(td, "subMenuIcon-selected", false);
            }
        }
        if (item != null) {
            item.setSelectionStyle(true);
            if (this.vertical && DOM.getChildCount(tr = DOM.getParent(item.getElement())) == 2) {
                td = DOM.getChild(tr, 1);
                MenuBar.setStyleName(td, "subMenuIcon-selected", true);
            }
            Accessibility.setState(this.getElement(), "aria-activedescendant", DOM.getElementAttribute(item.getElement(), "id"));
        }
        this.selectedItem = item;
    }

    void setMenuItemDebugIds(String baseID) {
        int itemCount = 0;
        for (MenuItem item : this.items) {
            item.ensureDebugId(baseID + "-item" + itemCount);
            ++itemCount;
        }
    }

    void updateSubmenuIcon(MenuItem item) {
        if (!this.vertical) {
            return;
        }
        int idx = this.allItems.indexOf(item);
        if (idx == -1) {
            return;
        }
        Element container = this.getItemContainerElement();
        Element tr = DOM.getChild(container, idx);
        int tdCount = DOM.getChildCount(tr);
        MenuBar submenu = item.getSubMenu();
        if (submenu == null) {
            if (tdCount == 2) {
                DOM.removeChild(tr, DOM.getChild(tr, 1));
            }
            this.setItemColSpan(item, 2);
        } else if (tdCount == 1) {
            this.setItemColSpan(item, 1);
            Element td = DOM.createTD();
            DOM.setElementProperty(td, "vAlign", "middle");
            DOM.setInnerHTML(td, this.images.menuBarSubMenuIcon().getHTML());
            MenuBar.setStyleName(td, "subMenuIcon");
            DOM.appendChild(tr, td);
        }
    }

    private void addItemElement(int beforeIndex, Element tdElem) {
        if (this.vertical) {
            Element tr = DOM.createTR();
            DOM.insertChild(this.body, tr, beforeIndex);
            DOM.appendChild(tr, tdElem);
        } else {
            Element tr = DOM.getChild(this.body, 0);
            DOM.insertChild(tr, tdElem, beforeIndex);
        }
    }

    private void close() {
        if (this.parentMenu != null) {
            this.parentMenu.popup.hide();
        }
    }

    private void eatEvent(Event event) {
        DOM.eventCancelBubble(event, true);
        DOM.eventPreventDefault(event);
    }

    private MenuItem findItem(Element hItem) {
        for (MenuItem item : this.items) {
            if (!DOM.isOrHasChild(item.getElement(), hItem)) continue;
            return item;
        }
        return null;
    }

    private void focus() {
        FocusPanel.impl.focus(this.getElement());
    }

    private Element getItemContainerElement() {
        if (this.vertical) {
            return this.body;
        }
        return DOM.getChild(this.body, 0);
    }

    private void init(boolean vertical, MenuBarImages images) {
        this.images = images;
        Element table = DOM.createTable();
        this.body = DOM.createTBody();
        DOM.appendChild(table, this.body);
        if (!vertical) {
            Element tr = DOM.createTR();
            DOM.appendChild(this.body, tr);
        }
        this.vertical = vertical;
        Element outer = FocusPanel.impl.createFocusable();
        DOM.appendChild(outer, table);
        this.setElement(outer);
        Accessibility.setRole(this.getElement(), "menubar");
        this.sinkEvents(2225);
        this.setStyleName(STYLENAME_DEFAULT);
        if (vertical) {
            this.addStyleDependentName("vertical");
        } else {
            this.addStyleDependentName("horizontal");
        }
        DOM.setStyleAttribute(this.getElement(), "outline", "0px");
        DOM.setElementAttribute(this.getElement(), "hideFocus", "true");
    }

    private void moveDown() {
        if (this.selectFirstItemIfNoneSelected()) {
            return;
        }
        if (this.vertical) {
            this.selectNextItem();
        } else if (!(this.selectedItem.getSubMenu() == null || this.selectedItem.getSubMenu().getItems().isEmpty() || this.shownChildMenu != null && this.shownChildMenu.getSelectedItem() != null)) {
            if (this.shownChildMenu == null) {
                this.doItemAction(this.selectedItem, false);
            }
            this.selectedItem.getSubMenu().focus();
        } else if (this.parentMenu != null) {
            if (this.parentMenu.vertical) {
                this.parentMenu.selectNextItem();
            } else {
                this.parentMenu.moveDown();
            }
        }
    }

    private void moveToNextItem() {
        if (this.selectFirstItemIfNoneSelected()) {
            return;
        }
        if (!this.vertical) {
            this.selectNextItem();
        } else if (!(this.selectedItem.getSubMenu() == null || this.selectedItem.getSubMenu().getItems().isEmpty() || this.shownChildMenu != null && this.shownChildMenu.getSelectedItem() != null)) {
            if (this.shownChildMenu == null) {
                this.doItemAction(this.selectedItem, false);
            }
            this.selectedItem.getSubMenu().focus();
        } else if (this.parentMenu != null) {
            if (!this.parentMenu.vertical) {
                this.parentMenu.selectNextItem();
            } else {
                this.parentMenu.moveToNextItem();
            }
        }
    }

    private void moveToPrevItem() {
        if (this.selectFirstItemIfNoneSelected()) {
            return;
        }
        if (!this.vertical) {
            this.selectPrevItem();
        } else if (this.parentMenu != null && !this.parentMenu.vertical) {
            this.parentMenu.selectPrevItem();
        } else {
            this.close();
        }
    }

    private void moveUp() {
        if (this.selectFirstItemIfNoneSelected()) {
            return;
        }
        if (this.shownChildMenu == null && this.vertical) {
            this.selectPrevItem();
        } else if (this.parentMenu != null && this.parentMenu.vertical) {
            this.parentMenu.selectPrevItem();
        } else {
            this.close();
        }
    }

    private void onHide() {
        if (this.shownChildMenu != null) {
            this.shownChildMenu.onHide();
            this.popup.hide();
            this.focus();
        }
    }

    private void onShow() {
        this.selectItem(null);
    }

    private void openPopup(final MenuItem item) {
        if (this.parentMenu != null && this.parentMenu.popup != null) {
            this.parentMenu.popup.setPreviewingAllNativeEvents(false);
        }
        this.popup = new DecoratedPopupPanel(true, false, "menuPopup"){
            {
                super(x0, x1, x2);
                this.setWidget(item.getSubMenu());
                this.setPreviewingAllNativeEvents(true);
                item.getSubMenu().onShow();
            }

            protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                if (!event.isCanceled()) {
                    switch (event.getTypeInt()) {
                        case 4: {
                            EventTarget target = event.getNativeEvent().getEventTarget();
                            Element parentMenuElement = item.getParentMenu().getElement();
                            if (parentMenuElement.isOrHasChild(Element.as(target))) {
                                event.cancel();
                                return;
                            }
                            super.onPreviewNativeEvent(event);
                            if (event.isCanceled()) {
                                MenuBar.this.selectItem(null);
                            }
                            return;
                        }
                    }
                }
                super.onPreviewNativeEvent(event);
            }
        };
        this.popup.setAnimationType(PopupPanel.AnimationType.ONE_WAY_CORNER);
        this.popup.setAnimationEnabled(this.isAnimationEnabled);
        this.popup.setStyleName("gwt-MenuBarPopup");
        String primaryStyleName = this.getStylePrimaryName();
        if (!STYLENAME_DEFAULT.equals(primaryStyleName)) {
            this.popup.addStyleName(primaryStyleName + "Popup");
        }
        this.popup.addPopupListener(this);
        this.shownChildMenu = item.getSubMenu();
        item.getSubMenu().parentMenu = this;
        this.popup.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                if (LocaleInfo.getCurrentLocale().isRTL()) {
                    if (MenuBar.this.vertical) {
                        MenuBar.this.popup.setPopupPosition(MenuBar.this.getAbsoluteLeft() - offsetWidth + 1, item.getAbsoluteTop());
                    } else {
                        MenuBar.this.popup.setPopupPosition(item.getAbsoluteLeft() + item.getOffsetWidth() - offsetWidth, MenuBar.this.getAbsoluteTop() + MenuBar.this.getOffsetHeight() - 1);
                    }
                } else if (MenuBar.this.vertical) {
                    MenuBar.this.popup.setPopupPosition(MenuBar.this.getAbsoluteLeft() + MenuBar.this.getOffsetWidth() - 1, item.getAbsoluteTop());
                } else {
                    MenuBar.this.popup.setPopupPosition(item.getAbsoluteLeft(), MenuBar.this.getAbsoluteTop() + MenuBar.this.getOffsetHeight() - 1);
                }
            }
        });
    }

    private boolean removeItemElement(UIObject item) {
        int idx = this.allItems.indexOf(item);
        if (idx == -1) {
            return false;
        }
        Element container = this.getItemContainerElement();
        DOM.removeChild(container, DOM.getChild(container, idx));
        this.allItems.remove(idx);
        return true;
    }

    private boolean selectFirstItemIfNoneSelected() {
        if (this.selectedItem == null) {
            MenuItem nextItem = this.items.get(0);
            this.selectItem(nextItem);
            return true;
        }
        return false;
    }

    private void selectNextItem() {
        if (this.selectedItem == null) {
            return;
        }
        int index = this.items.indexOf(this.selectedItem);
        assert (index != -1);
        MenuItem itemToBeSelected = index < this.items.size() - 1 ? this.items.get(index + 1) : this.items.get(0);
        this.selectItem(itemToBeSelected);
        if (this.shownChildMenu != null) {
            this.doItemAction(itemToBeSelected, false);
        }
    }

    private void selectPrevItem() {
        if (this.selectedItem == null) {
            return;
        }
        int index = this.items.indexOf(this.selectedItem);
        assert (index != -1);
        MenuItem itemToBeSelected = index > 0 ? this.items.get(index - 1) : this.items.get(this.items.size() - 1);
        this.selectItem(itemToBeSelected);
        if (this.shownChildMenu != null) {
            this.doItemAction(itemToBeSelected, false);
        }
    }

    private void setItemColSpan(UIObject item, int colspan) {
        DOM.setElementPropertyInt(item.getElement(), "colSpan", colspan);
    }

    static interface MenuBarImagesRTL
    extends MenuBarImages {
        @ImageBundle.Resource(value="menuBarSubMenuIcon_rtl.gif")
        public AbstractImagePrototype menuBarSubMenuIcon();
    }

    public static interface MenuBarImages
    extends ImageBundle {
        public AbstractImagePrototype menuBarSubMenuIcon();
    }
}

