/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.FBAppConf;
import com.google.code.facebookapi.FBAppConfs;
import com.google.code.facebookapi.FBWebRequest;
import com.google.code.facebookapi.FBWebSession;
import com.google.code.facebookapi.FacebookParam;
import com.google.code.facebookapi.FacebookSignatureUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FbWebHelper {
    public static FBWebRequest attainFBWebRequest(FBAppConf appConf, HttpServletRequest httpRequest) throws IOException, ServletException {
        return FbWebHelper.attainFBWebRequest(appConf, false, httpRequest);
    }

    public static FBWebRequest attainFBWebRequest(FBAppConf appConf, boolean ignoreCookies, HttpServletRequest httpRequest) throws IOException, ServletException {
        HttpSession httpSession = httpRequest.getSession();
        String apiKey = appConf.getApiKey();
        String secret = appConf.getSecret();
        SortedMap<String, String> params = null;
        params = FacebookSignatureUtil.pulloutFbSigParams(FbWebHelper.getRequestParameterMap(httpRequest));
        boolean validParams = (params = FacebookSignatureUtil.getVerifiedParams("fb_sig", params, secret)) != null;
        SortedMap<String, String> cookies = null;
        if (!ignoreCookies) {
            cookies = FbWebHelper.pulloutFbConnectCookies(httpRequest.getCookies(), apiKey);
            cookies = FacebookSignatureUtil.getVerifiedParams(apiKey, cookies, secret);
        }
        boolean validCookies = cookies != null;
        String skey = "fbsess_" + apiKey;
        FBWebSession session = (FBWebSession)httpSession.getAttribute(skey);
        if (session == null) {
            session = new FBWebSession(appConf);
            httpSession.setAttribute(skey, (Object)session);
        }
        FBWebRequest request = new FBWebRequest(appConf, session, params, cookies, validParams || validCookies);
        boolean updateSession = false;
        if (validParams) {
            boolean bl = updateSession = updateSession || FbWebHelper.updateRequestSessionFromParams(params, request, session);
        }
        if (validCookies) {
            boolean bl = updateSession = updateSession || FbWebHelper.updateSessionFromCookies(cookies, session);
        }
        if (updateSession) {
            httpSession.setAttribute(skey, (Object)session);
        }
        return request;
    }

    public static FBWebSession attainFBWebSession(FBAppConf appConf, HttpServletRequest httpRequest) throws IOException, ServletException {
        String apiKey = appConf.getApiKey();
        String secret = appConf.getSecret();
        Cookie[] hcookies = httpRequest.getCookies();
        SortedMap<String, String> cookies = null;
        cookies = FbWebHelper.pulloutFbConnectCookies(hcookies, apiKey);
        if ((cookies = FacebookSignatureUtil.getVerifiedParams(apiKey, cookies, secret)) != null) {
            FBWebSession session = new FBWebSession(appConf);
            FbWebHelper.updateSessionFromCookies(cookies, session);
            return session;
        }
        return new FBWebSession(appConf);
    }

    public static Map<String, FBWebSession> attainFBWebSessions(FBAppConfs appConfs, HttpServletRequest httpRequest) throws IOException, ServletException {
        HashMap<String, FBWebSession> out = new HashMap<String, FBWebSession>();
        Cookie[] hcookies = httpRequest.getCookies();
        Map<String, SortedMap<String, String>> cookiesMap = FbWebHelper.pulloutFbConnectCookies(hcookies, appConfs);
        for (Map.Entry<String, SortedMap<String, String>> entry : cookiesMap.entrySet()) {
            String apiKey = entry.getKey();
            SortedMap<String, String> cookies = entry.getValue();
            FBAppConf appConf = appConfs.getConfByApiKey(apiKey);
            if ((cookies = FacebookSignatureUtil.getVerifiedParams(apiKey, cookies, appConf.getSecret())) == null) continue;
            FBWebSession session = new FBWebSession(appConf);
            FbWebHelper.updateSessionFromCookies(cookies, session);
            out.put(apiKey, session);
        }
        SortedMap<String, String> params = null;
        params = FacebookSignatureUtil.pulloutFbSigParams(FbWebHelper.getRequestParameterMap(httpRequest));
        String apiKey = (String)params.get("fb_sig_api_key");
        FBAppConf appConf = appConfs.getConfByApiKey(apiKey);
        if (appConf != null && (params = FacebookSignatureUtil.getVerifiedParams("fb_sig", params, appConf.getSecret())) != null) {
            FBWebSession session = (FBWebSession)out.get(apiKey);
            if (session == null) {
                session = new FBWebSession(appConf);
            }
            FbWebHelper.updateSessionFromParams(params, session);
            out.put(apiKey, session);
        }
        return out;
    }

    public static boolean updateRequestSessionFromParams(SortedMap<String, String> params, FBWebRequest request, FBWebSession session) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        String sessionKey = session.getSessionKey();
        Long userId = session.getUserId();
        request.setInCanvas(FbWebHelper.getFbParamBoolean(FacebookParam.IN_CANVAS, params));
        request.setInIframe(FbWebHelper.getFbParamBoolean(FacebookParam.IN_IFRAME, params) || !request.isInCanvas());
        request.setInProfileTab(FbWebHelper.getFbParamBoolean(FacebookParam.IN_PROFILE_TAB, params));
        if (!request.isInProfileTab()) {
            sessionKey = FbWebHelper.getFbParam(FacebookParam.SESSION_KEY, params);
            userId = FbWebHelper.getFbParamLong(FacebookParam.USER, params);
            Long canvas_user = FbWebHelper.getFbParamLong(FacebookParam.CANVAS_USER, params);
            if (canvas_user != null) {
                userId = canvas_user;
            }
        } else {
            sessionKey = FbWebHelper.getFbParam(FacebookParam.PROFILE_SESSION_KEY, params);
            userId = FbWebHelper.getFbParamLong(FacebookParam.PROFILE_USER, params);
        }
        Date sessionExpires = FbWebHelper.getFbParamExpiresDate(FacebookParam.EXPIRES, params);
        String sessionSecret = FbWebHelper.getFbParam(FacebookParam.SS, params);
        boolean appUser = FbWebHelper.getFbParamBooleanN(FacebookParam.ADDED, params);
        return session.update(sessionKey, sessionExpires, userId, sessionSecret, appUser);
    }

    public static boolean updateSessionFromParams(SortedMap<String, String> params, FBWebSession session) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        String sessionKey = session.getSessionKey();
        Long userId = session.getUserId();
        boolean inProfileTab = FbWebHelper.getFbParamBoolean(FacebookParam.IN_PROFILE_TAB, params);
        if (!inProfileTab) {
            sessionKey = FbWebHelper.getFbParam(FacebookParam.SESSION_KEY, params);
            userId = FbWebHelper.getFbParamLong(FacebookParam.USER, params);
            Long canvas_user = FbWebHelper.getFbParamLong(FacebookParam.CANVAS_USER, params);
            if (canvas_user != null) {
                userId = canvas_user;
            }
        } else {
            sessionKey = FbWebHelper.getFbParam(FacebookParam.PROFILE_SESSION_KEY, params);
            userId = FbWebHelper.getFbParamLong(FacebookParam.PROFILE_USER, params);
        }
        Date sessionExpires = FbWebHelper.getFbParamExpiresDate(FacebookParam.EXPIRES, params);
        String sessionSecret = FbWebHelper.getFbParam(FacebookParam.SS, params);
        boolean appUser = FbWebHelper.getFbParamBooleanN(FacebookParam.ADDED, params);
        return session.update(sessionKey, sessionExpires, userId, sessionSecret, appUser);
    }

    public static boolean updateSessionFromCookies(SortedMap<String, String> cookies, FBWebSession session) {
        if (cookies == null || cookies.isEmpty()) {
            return false;
        }
        String apiKey = session.getAppConf().getApiKey();
        String sessionKey = (String)cookies.get(apiKey + "_session_key");
        Date sessionExpires = FbWebHelper.toExpiresDate((String)cookies.get(apiKey + "_expires"));
        Long userId = FbWebHelper.toLong((String)cookies.get(apiKey + "_user"));
        String sessionSecret = (String)cookies.get(apiKey + "_ss");
        return session.update(sessionKey, sessionExpires, userId, sessionSecret, true);
    }

    private static Map<String, String[]> getRequestParameterMap(HttpServletRequest request) {
        return request.getParameterMap();
    }

    public static SortedMap<String, String> pulloutFbConnectCookies(Cookie[] cookies, String apiKey) {
        TreeMap<String, String> out = new TreeMap<String, String>();
        for (Cookie cookie : cookies) {
            String key = cookie.getName();
            if (!key.startsWith(apiKey)) continue;
            out.put(key, cookie.getValue());
        }
        return out;
    }

    public static Map<String, SortedMap<String, String>> pulloutFbConnectCookies(Cookie[] cookies, FBAppConfs appConfs) {
        HashMap<String, SortedMap<String, String>> out = new HashMap<String, SortedMap<String, String>>();
        HashSet<String> existsSet = new HashSet<String>();
        for (Cookie cookie : cookies) {
            String apiKey;
            String key = cookie.getName();
            String[] split = key.split("_");
            if (split.length != 1 && split.length != 2 || !existsSet.contains(apiKey = split[0]) && !appConfs.hasConfByApiKey(apiKey)) continue;
            existsSet.add(apiKey);
            TreeMap<String, String> vals = (TreeMap<String, String>)out.get(apiKey);
            if (vals == null) {
                vals = new TreeMap<String, String>();
                out.put(apiKey, vals);
            }
            vals.put(key, cookie.getValue());
        }
        return out;
    }

    public static String getFbParam(FacebookParam key, Map<String, String> params) {
        if (params != null) {
            return params.get(key.toString());
        }
        return null;
    }

    public static Date getFbParamDate(FacebookParam key, Map<String, String> params) {
        return FbWebHelper.toDate(FbWebHelper.getFbParam(key, params));
    }

    public static Date toDate(String t) {
        return FbWebHelper.toDate(FbWebHelper.toLong(t));
    }

    public static Date toDate(Long l) {
        if (l != null) {
            return new Date(l * 1000L);
        }
        return null;
    }

    public static Date getFbParamExpiresDate(FacebookParam key, Map<String, String> params) {
        return FbWebHelper.toExpiresDate(FbWebHelper.getFbParam(key, params));
    }

    public static Date toExpiresDate(String t) {
        return FbWebHelper.toExpiresDate(FbWebHelper.toLong(t));
    }

    public static Date toExpiresDate(Long l) {
        if (l != null) {
            if (l <= 0L) {
                return new Date(Long.MAX_VALUE);
            }
            return new Date(l * 1000L);
        }
        return null;
    }

    public static Long toLong(String t) {
        if (t != null) {
            return Long.parseLong(t);
        }
        return null;
    }

    public static Long getFbParamLong(FacebookParam key, Map<String, String> params) {
        return FbWebHelper.toLong(FbWebHelper.getFbParam(key, params));
    }

    public static boolean getFbParamBoolean(FacebookParam key, Map<String, String> params) {
        Long t = FbWebHelper.getFbParamLong(key, params);
        return t != null && t > 0L;
    }

    public static Boolean getFbParamBooleanN(FacebookParam key, Map<String, String> params) {
        Long t = FbWebHelper.getFbParamLong(key, params);
        if (t != null) {
            return t > 0L;
        }
        return null;
    }

    public static boolean fbParamEquals(FacebookParam key, String val, Map<String, String> params) {
        String param = FbWebHelper.getFbParam(key, params);
        return val.equals(param);
    }
}

