/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacebookSignatureUtil {
    protected static Log log = LogFactory.getLog(FacebookSignatureUtil.class);

    public static SortedMap<String, String> pulloutFbSigParams(Map<String, String[]> reqParams) {
        TreeMap<String, String> out = new TreeMap<String, String>();
        for (Map.Entry<String, String[]> entry : reqParams.entrySet()) {
            String key = entry.getKey();
            String[] values = entry.getValue();
            if (values.length <= 0 || !key.startsWith("fb_sig")) continue;
            out.put(key, values[0]);
        }
        return out;
    }

    public static boolean verifySignature(SortedMap<String, String> params, String secret) {
        return FacebookSignatureUtil.getVerifiedParams("fb_sig", params, secret) != null;
    }

    public static SortedMap<String, String> getVerifiedParams(String prefix, SortedMap<String, String> map, String secret) {
        TreeMap<String, String> out = new TreeMap<String, String>();
        String prefix2 = prefix + "_";
        String sig = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals(prefix)) {
                sig = entry.getValue();
                continue;
            }
            if (!key.startsWith(prefix2)) continue;
            key = key.substring(prefix2.length());
            out.put(key, entry.getValue());
        }
        String sigGen = FacebookSignatureUtil.generateSignature(out, secret);
        if (StringUtils.equals(sig, (String)sigGen)) {
            return out;
        }
        return null;
    }

    public static String generateSignature(SortedMap<String, String> params, String secret) {
        StringBuilder sb = FacebookSignatureUtil.generateBaseString(params);
        sb.append(secret);
        return FacebookSignatureUtil.generateMD5(sb.toString());
    }

    public static StringBuilder generateBaseString(SortedMap<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            sb.append(key);
            sb.append("=");
            String value = entry.getValue();
            sb.append(value == null ? "" : value);
        }
        return sb;
    }

    public static String generateMD5(String value) {
        try {
            byte[] bytes;
            MessageDigest md = MessageDigest.getInstance("MD5");
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                bytes = value.getBytes();
            }
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest(bytes)) {
                result.append(Integer.toHexString((b & 0xF0) >>> 4));
                result.append(Integer.toHexString(b & 0xF));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String generateEmailHash(String email) {
        email = email.trim().toLowerCase();
        CRC32 crc = new CRC32();
        crc.update(email.getBytes());
        String md5 = FacebookSignatureUtil.generateMD5(email);
        return crc.getValue() + "_" + md5;
    }
}

