/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.CommunicationStrategy;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommunicationStrategy
implements CommunicationStrategy {
    protected static Log log = LogFactory.getLog(DefaultCommunicationStrategy.class);
    private static final String ENCODING = "UTF-8";
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 1024;
    private int connectionTimeout = -1;
    private int readTimeout = -1;

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public DefaultCommunicationStrategy() {
    }

    public DefaultCommunicationStrategy(int connectionTimeout, int readTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postRequest(URL serverUrl, SortedMap<String, String> params) throws IOException {
        String string;
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            conn = (HttpURLConnection)serverUrl.openConnection();
            if (this.connectionTimeout != -1) {
                conn.setConnectTimeout(this.connectionTimeout);
            }
            if (this.readTimeout != -1) {
                conn.setReadTimeout(this.readTimeout);
            }
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);
            conn.connect();
            out = conn.getOutputStream();
            String paramString = null == params ? "" : BasicClientHelper.delimit(params.entrySet(), "&", "=", true);
            out.write(paramString.toString().getBytes(ENCODING));
            in = conn.getInputStream();
            string = BasicClientHelper.toString(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(in);
            BasicClientHelper.close(out);
            BasicClientHelper.disconnect(conn);
            throw throwable;
        }
        BasicClientHelper.close(in);
        BasicClientHelper.close(out);
        BasicClientHelper.disconnect(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postRequest(URL serverUrl, SortedMap<String, String> params, String fileName, InputStream fileStream) throws IOException {
        String string;
        HttpURLConnection con = null;
        OutputStream urlOut = null;
        InputStream in = null;
        try {
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            con = (HttpURLConnection)serverUrl.openConnection();
            if (this.connectionTimeout != -1) {
                con.setConnectTimeout(this.connectionTimeout);
            }
            if (this.readTimeout != -1) {
                con.setReadTimeout(this.readTimeout);
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            urlOut = con.getOutputStream();
            DataOutputStream out = new DataOutputStream(urlOut);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-Type: text/plain;charset=utf-8\r\n");
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"" + CRLF);
                out.writeBytes(CRLF);
                byte[] valueBytes = entry.getValue().toString().getBytes(ENCODING);
                out.write(valueBytes);
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-Type: image\r\n");
            out.writeBytes("Content-disposition: form-data; filename=\"" + fileName + "\"" + CRLF);
            out.writeBytes(CRLF);
            byte[] buf = new byte[1024];
            int len = 0;
            while (len >= 0) {
                out.write(buf, 0, len);
                len = fileStream.read(buf);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            in = con.getInputStream();
            string = BasicClientHelper.toString(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(urlOut);
            BasicClientHelper.close(in);
            BasicClientHelper.disconnect(con);
            throw throwable;
        }
        BasicClientHelper.close(urlOut);
        BasicClientHelper.close(in);
        BasicClientHelper.disconnect(con);
        return string;
    }
}

