/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.alloydb;

import com.google.cloud.alloydb.ConnectorRegistry;
import com.google.cloud.spring.autoconfigure.alloydb.AlloyDbProperties;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AlloyDbEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String JDBC_URL_TEMPLATE = "jdbc:postgresql:///%s?socketFactory=com.google.cloud.alloydb.SocketFactory";
    private static final String JDBC_DRIVER_CLASS = "org.postgresql.Driver";
    private static final String DEFAULT_USERNAME = "postgres";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().contains("bootstrap")) {
            return;
        }
        boolean isAlloyDbEnabled = Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.alloydb.enabled", "true"));
        if (!isAlloyDbEnabled) {
            return;
        }
        String propertiesPrefix = AlloyDbProperties.class.getAnnotation(ConfigurationProperties.class).value();
        AlloyDbProperties alloyDbProperties = (AlloyDbProperties)new Binder(ConfigurationPropertySources.get((Environment)environment), (PlaceholdersResolver)new NonSecretsManagerPropertiesPlaceholdersResolver((Environment)environment), null, null, null).bind(propertiesPrefix, AlloyDbProperties.class).orElse((Object)new AlloyDbProperties());
        if (this.isOnClasspath("com.google.cloud.alloydb.SocketFactory") && this.isOnClasspath(JDBC_DRIVER_CLASS)) {
            HashMap<String, String> fallbackMap = new HashMap<String, String>();
            fallbackMap.put("spring.datasource.username", DEFAULT_USERNAME);
            fallbackMap.put("spring.datasource.driver-class-name", JDBC_DRIVER_CLASS);
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("ALLOYDB_DATA_SOURCE_FALLBACK", fallbackMap));
            HashMap<String, String> primaryMap = new HashMap<String, String>();
            primaryMap.put("spring.datasource.url", this.getJdbcUrl(alloyDbProperties));
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("ALLOYDB_DATA_SOURCE_URL", primaryMap));
            ConnectorRegistry.addArtifactId((String)("spring-cloud-gcp-alloydb/" + this.getClass().getPackage().getImplementationVersion()));
        }
    }

    private String getJdbcUrl(AlloyDbProperties properties) {
        Object jdbcUrl = String.format(JDBC_URL_TEMPLATE, properties.getDatabaseName());
        if (StringUtils.hasText((String)properties.getInstanceConnectionUri())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbInstanceName=" + properties.getInstanceConnectionUri();
        }
        if (StringUtils.hasText((String)properties.getIpType())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbIpType=" + properties.getIpType();
        }
        if (properties.isEnableIamAuth()) {
            jdbcUrl = (String)jdbcUrl + "&alloydbEnableIAMAuth=true&sslmode=disable";
        }
        if (StringUtils.hasText((String)properties.getAdminServiceEndpoint())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbAdminServiceEndpoint=" + properties.getAdminServiceEndpoint();
        }
        if (StringUtils.hasText((String)properties.getQuotaProject())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbQuotaProject=" + properties.getQuotaProject();
        }
        if (StringUtils.hasText((String)properties.getTargetPrincipal())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbTargetPrincipal=" + properties.getTargetPrincipal();
        }
        if (StringUtils.hasText((String)properties.getDelegates())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbDelegates=" + properties.getDelegates();
        }
        if (StringUtils.hasText((String)properties.getNamedConnector())) {
            jdbcUrl = (String)jdbcUrl + "&alloydbNamedConnector=" + properties.getNamedConnector();
        }
        return jdbcUrl;
    }

    private boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, null);
    }

    private static class NonSecretsManagerPropertiesPlaceholdersResolver
    implements PlaceholdersResolver {
        private PlaceholdersResolver resolver;

        NonSecretsManagerPropertiesPlaceholdersResolver(Environment environment) {
            this.resolver = new PropertySourcesPlaceholdersResolver(environment);
        }

        public Object resolvePlaceholders(Object value) {
            if (value.toString().contains("sm://")) {
                return value;
            }
            return this.resolver.resolvePlaceholders(value);
        }
    }
}

