/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

public final class LocalDatastoreServiceTestConfig
implements LocalServiceTestConfig {
    private Boolean noStorage = true;
    private Integer maxQueryLifetimeMs;
    private Integer maxTxnLifetimeMs;
    private Integer storeDelayMs;
    private String backingStoreLocation;
    private Boolean noIndexAutoGen = true;

    public boolean isNoStorage() {
        return this.noStorage;
    }

    public LocalDatastoreServiceTestConfig setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
        return this;
    }

    public Integer getMaxQueryLifetimeMs() {
        return this.maxQueryLifetimeMs;
    }

    public LocalDatastoreServiceTestConfig setMaxQueryLifetimeMs(int maxQueryLifetimeMs) {
        this.maxQueryLifetimeMs = maxQueryLifetimeMs;
        return this;
    }

    public Integer getMaxTxnLifetimeMs() {
        return this.maxTxnLifetimeMs;
    }

    public LocalDatastoreServiceTestConfig setMaxTxnLifetimeMs(int maxTxnLifetimeMs) {
        this.maxTxnLifetimeMs = maxTxnLifetimeMs;
        return this;
    }

    public Integer getStoreDelayMs() {
        return this.storeDelayMs;
    }

    public LocalDatastoreServiceTestConfig setStoreDelayMs(int storeDelayMs) {
        this.storeDelayMs = storeDelayMs;
        return this;
    }

    public String getBackingStoreLocation() {
        return this.backingStoreLocation;
    }

    public LocalDatastoreServiceTestConfig setBackingStoreLocation(String backingStoreLocation) {
        this.backingStoreLocation = backingStoreLocation;
        return this;
    }

    public boolean isNoIndexAutoGen() {
        return this.noIndexAutoGen;
    }

    public LocalDatastoreServiceTestConfig setNoIndexAutoGen(boolean noIndexAutoGen) {
        this.noIndexAutoGen = noIndexAutoGen;
        return this;
    }

    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("datastore.no_storage", this.noStorage.toString());
        if (this.maxQueryLifetimeMs != null) {
            proxy.setProperty("datastore.max_query_lifetime", Integer.valueOf(this.maxQueryLifetimeMs).toString());
        }
        if (this.maxTxnLifetimeMs != null) {
            proxy.setProperty("datastore.max_txn_lifetime", Integer.valueOf(this.maxTxnLifetimeMs).toString());
        }
        if (this.storeDelayMs != null) {
            proxy.setProperty("datastore.store_delay", Integer.valueOf(this.storeDelayMs).toString());
        }
        if (this.backingStoreLocation != null) {
            proxy.setProperty("datastore.backing_store", this.backingStoreLocation);
        }
        proxy.setProperty("datastore.no_index_auto_gen", this.noIndexAutoGen.toString());
    }

    public void tearDown() {
        LocalDatastoreService datastoreService = LocalDatastoreServiceTestConfig.getLocalDatastoreService();
        datastoreService.clearProfiles();
    }

    public static LocalDatastoreService getLocalDatastoreService() {
        return (LocalDatastoreService)LocalServiceTestHelper.getLocalService("datastore_v3");
    }
}

