/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalStatement;
import com.google.appengine.api.rdbms.dev.ResultState;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalConnection {
    private static final Logger logger = Logger.getLogger(LocalConnection.class.getCanonicalName());
    private final Connection conn;
    private final DatabaseMetaData dmd;
    private final Map<Long, Savepoint> savepointsById = new HashMap<Long, Savepoint>();
    private final Map<String, Savepoint> savepointsByName = new HashMap<String, Savepoint>();
    private final Map<Long, LocalStatement> statementsById = new HashMap<Long, LocalStatement>();
    private final AtomicLong nextStatementId = new AtomicLong(0L);

    static LocalConnection create(Connection connection) throws SQLException {
        return new LocalConnection(connection, connection.getMetaData());
    }

    private LocalConnection(Connection conn, DatabaseMetaData dmd) {
        this.conn = conn;
        this.dmd = dmd;
    }

    Connection getConnection() {
        return this.conn;
    }

    DatabaseMetaData getMetaData() {
        return this.dmd;
    }

    Map<Long, Savepoint> getSavepointsById() {
        return this.savepointsById;
    }

    Map<String, Savepoint> getSavepointsByName() {
        return this.savepointsByName;
    }

    ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        if (request.hasStatementId()) {
            LocalStatement statement = this.getStatementById(request.getStatementId());
            ExecResponse response = statement.next();
            ResultState result = statement.getResultState();
            if (!result.hasMoreResults() && !result.hasMoreRows()) {
                this.removeStatementById(statement.getStatementId());
                statement.close();
            }
            return response;
        }
        LocalStatement statement = LocalStatement.create(this.nextStatementId.incrementAndGet(), this);
        ExecResponse response = statement.exec(status, request);
        ResultState result = statement.getResultState();
        if (result.hasMoreResults() || result.hasMoreRows()) {
            this.storeStatement(statement);
        } else {
            statement.close();
        }
        return response;
    }

    ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        ExecOpResponse.Builder responseBuilder = ExecOpResponse.newBuilder();
        Client.OpProto op = request.getOp();
        try {
            switch (op.getType()) {
                case NATIVE_SQL: {
                    String response = this.conn.nativeSQL(op.getSql());
                    responseBuilder.setNativeSql(response);
                    break;
                }
                case ROLLBACK: {
                    if (op.hasSavepoint()) {
                        Savepoint savepoint = this.getSavepoint(op);
                        this.conn.rollback(savepoint);
                        break;
                    }
                    this.conn.rollback();
                    break;
                }
                case SET_CATALOG: {
                    this.conn.setCatalog(op.getCatalog());
                    break;
                }
                case SET_SAVEPOINT: {
                    Savepoint savepoint;
                    if (op.hasSavepoint() && op.getSavepoint().hasName()) {
                        savepoint = this.conn.setSavepoint(op.getSavepoint().getName());
                        this.getSavepointsByName().put(op.getSavepoint().getName(), savepoint);
                    } else {
                        savepoint = this.conn.setSavepoint();
                        this.getSavepointsById().put(Integer.valueOf(savepoint.getSavepointId()).longValue(), savepoint);
                    }
                    responseBuilder.setSavepoint(this.savepointAsClientSavepoint(savepoint));
                    break;
                }
                case SET_AUTO_COMMIT: {
                    this.conn.setAutoCommit(op.getAutoCommit());
                    break;
                }
                case SET_READ_ONLY: {
                    this.conn.setReadOnly(op.getReadOnly());
                    break;
                }
                case SET_TRANSACTION_ISOLATION_LEVEL: {
                    this.conn.setTransactionIsolation(op.getTransactionIsolationLevel().getNumber());
                    break;
                }
                case CLOSE_STATEMENT: {
                    LocalStatement stmt = this.getStatementById(op.getStatementId());
                    if (stmt != null) {
                        stmt.close();
                    }
                    break;
                }
                case COMMIT: {
                    this.conn.commit();
                    break;
                }
                case PING: {
                    try {
                        if (!this.conn.isValid(5000)) {
                            responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("Connection not valid"));
                        }
                    }
                    catch (AbstractMethodError e) {}
                    break;
                }
                case NEXT_RESULT: {
                    LocalStatement stmt = this.getStatementById(op.getStatementId());
                    if (stmt == null) {
                        responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("There is no next result"));
                        break;
                    }
                    if (!stmt.getNextResult(responseBuilder)) {
                        this.removeStatementById(stmt.getStatementId());
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported OpType " + op.getType());
                }
            }
        }
        catch (SQLException e) {
            if (op.hasStatementId()) {
                this.removeStatementById(op.getStatementId());
            }
            logger.log(Level.SEVERE, "Could not perform the requested operation: " + op.getType(), e);
            responseBuilder.setSqlException(Util.toClientSqlException(e));
        }
        return responseBuilder.build();
    }

    private Savepoint getSavepoint(Client.OpProto op) throws SQLException {
        Client.SavePoint clientSavepoint = op.getSavepoint();
        Savepoint savepoint = clientSavepoint.hasId() ? this.getSavepointsById().get(clientSavepoint.getId()) : this.getSavepointsByName().get(clientSavepoint.getName());
        if (savepoint == null) {
            throw new SQLException("savepoint not found");
        }
        return savepoint;
    }

    private Client.SavePoint savepointAsClientSavepoint(Savepoint savepoint) throws SQLException {
        Client.SavePoint.Builder builder = Client.SavePoint.newBuilder();
        try {
            builder.setName(savepoint.getSavepointName());
        }
        catch (SQLException e) {
            builder.setId((long)savepoint.getSavepointId());
            builder.setName("");
        }
        return builder.build();
    }

    void storeStatement(LocalStatement statement) {
        this.statementsById.put(statement.getStatementId(), statement);
    }

    LocalStatement getStatementById(long statementId) {
        return this.statementsById.get(statementId);
    }

    void removeStatementById(long statementId) {
        this.statementsById.remove(statementId);
    }

    void close() throws SQLException {
        for (LocalStatement stmt : this.statementsById.values()) {
            stmt.close();
        }
        this.statementsById.clear();
        this.conn.close();
    }
}

