/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/task.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * Spec of a task
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.TaskSpec}
 */
public final class TaskSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.TaskSpec)
    TaskSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TaskSpec.newBuilder() to construct.
  private TaskSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TaskSpec() {
    runnables_ = java.util.Collections.emptyList();
    lifecyclePolicies_ = java.util.Collections.emptyList();
    volumes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TaskSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_TaskSpec_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetEnvironments();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_TaskSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.TaskSpec.class,
            com.google.cloud.batch.v1.TaskSpec.Builder.class);
  }

  private int bitField0_;
  public static final int RUNNABLES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.Runnable> runnables_;

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.Runnable> getRunnablesList() {
    return runnables_;
  }

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.RunnableOrBuilder>
      getRunnablesOrBuilderList() {
    return runnables_;
  }

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  @java.lang.Override
  public int getRunnablesCount() {
    return runnables_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Runnable getRunnables(int index) {
    return runnables_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The sequence of one or more runnables (executable scripts,
   * executable containers, and/or barriers) for each task in this task group to
   * run. Each task runs this list of runnables in order. For a task to succeed,
   * all of its script and container runnables each must meet at least one of
   * the following conditions:
   *
   * + The runnable exited with a zero status.
   * + The runnable didn't finish, but you enabled its `background` subfield.
   * + The runnable exited with a non-zero status, but you enabled its
   *   `ignore_exit_status` subfield.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.RunnableOrBuilder getRunnablesOrBuilder(int index) {
    return runnables_.get(index);
  }

  public static final int COMPUTE_RESOURCE_FIELD_NUMBER = 3;
  private com.google.cloud.batch.v1.ComputeResource computeResource_;

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   *
   * @return Whether the computeResource field is set.
   */
  @java.lang.Override
  public boolean hasComputeResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   *
   * @return The computeResource.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.ComputeResource getComputeResource() {
    return computeResource_ == null
        ? com.google.cloud.batch.v1.ComputeResource.getDefaultInstance()
        : computeResource_;
  }

  /**
   *
   *
   * <pre>
   * ComputeResource requirements.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.ComputeResourceOrBuilder getComputeResourceOrBuilder() {
    return computeResource_ == null
        ? com.google.cloud.batch.v1.ComputeResource.getDefaultInstance()
        : computeResource_;
  }

  public static final int MAX_RUN_DURATION_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration maxRunDuration_;

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   *
   * @return Whether the maxRunDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxRunDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   *
   * @return The maxRunDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxRunDuration() {
    return maxRunDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRunDuration_;
  }

  /**
   *
   *
   * <pre>
   * Maximum duration the task should run before being automatically retried
   * (if enabled) or automatically failed. Format the value of this field
   * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
   * for 1 hour. The field accepts any value between 0 and the maximum listed
   * for the `Duration` field type at
   * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
   * the actual maximum run time for a job will be limited to the maximum run
   * time for a job listed at
   * https://cloud.google.com/batch/quotas#max-job-duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_run_duration = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxRunDurationOrBuilder() {
    return maxRunDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRunDuration_;
  }

  public static final int MAX_RETRY_COUNT_FIELD_NUMBER = 5;
  private int maxRetryCount_ = 0;

  /**
   *
   *
   * <pre>
   * Maximum number of retries on failures.
   * The default, 0, which means never retry.
   * The valid value range is [0, 10].
   * </pre>
   *
   * <code>int32 max_retry_count = 5;</code>
   *
   * @return The maxRetryCount.
   */
  @java.lang.Override
  public int getMaxRetryCount() {
    return maxRetryCount_;
  }

  public static final int LIFECYCLE_POLICIES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.LifecyclePolicy> lifecyclePolicies_;

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.LifecyclePolicy> getLifecyclePoliciesList() {
    return lifecyclePolicies_;
  }

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>
      getLifecyclePoliciesOrBuilderList() {
    return lifecyclePolicies_;
  }

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  @java.lang.Override
  public int getLifecyclePoliciesCount() {
    return lifecyclePolicies_.size();
  }

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicy getLifecyclePolicies(int index) {
    return lifecyclePolicies_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Lifecycle management schema when any task in a task group is failed.
   * Currently we only support one lifecycle policy.
   * When the lifecycle policy condition is met,
   * the action in the policy will execute.
   * If task execution result does not meet with the defined lifecycle
   * policy, we consider it as the default policy.
   * Default policy means if the exit code is 0, exit task.
   * If task ends with non-zero exit code, retry the task with max_retry_count.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicyOrBuilder getLifecyclePoliciesOrBuilder(
      int index) {
    return lifecyclePolicies_.get(index);
  }

  public static final int ENVIRONMENTS_FIELD_NUMBER = 6;

  private static final class EnvironmentsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1.TaskProto
                .internal_static_google_cloud_batch_v1_TaskSpec_EnvironmentsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environments_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironments() {
    if (environments_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentsDefaultEntryHolder.defaultEntry);
    }
    return environments_;
  }

  @java.lang.Deprecated
  public int getEnvironmentsCount() {
    return internalGetEnvironments().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean containsEnvironments(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironments().getMap().containsKey(key);
  }

  /** Use {@link #getEnvironmentsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironments() {
    return getEnvironmentsMap();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentsMap() {
    return internalGetEnvironments().getMap();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public /* nullable */ java.lang.String getEnvironmentsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironments().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use environment(non-plural) instead.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getEnvironmentsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironments().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int VOLUMES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.Volume> volumes_;

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.Volume> getVolumesList() {
    return volumes_;
  }

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Volume getVolumes(int index) {
    return volumes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Volumes to mount before running Tasks using this TaskSpec.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 10;
  private com.google.cloud.batch.v1.Environment environment_;

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   *
   * @return Whether the environment field is set.
   */
  @java.lang.Override
  public boolean hasEnvironment() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Environment getEnvironment() {
    return environment_ == null
        ? com.google.cloud.batch.v1.Environment.getDefaultInstance()
        : environment_;
  }

  /**
   *
   *
   * <pre>
   * Environment variables to set before running the Task.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.EnvironmentOrBuilder getEnvironmentOrBuilder() {
    return environment_ == null
        ? com.google.cloud.batch.v1.Environment.getDefaultInstance()
        : environment_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getComputeResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getMaxRunDuration());
    }
    if (maxRetryCount_ != 0) {
      output.writeInt32(5, maxRetryCount_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEnvironments(), EnvironmentsDefaultEntryHolder.defaultEntry, 6);
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(7, volumes_.get(i));
    }
    for (int i = 0; i < runnables_.size(); i++) {
      output.writeMessage(8, runnables_.get(i));
    }
    for (int i = 0; i < lifecyclePolicies_.size(); i++) {
      output.writeMessage(9, lifecyclePolicies_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getEnvironment());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getComputeResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMaxRunDuration());
    }
    if (maxRetryCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxRetryCount_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironments().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environments__ =
          EnvironmentsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, environments__);
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, volumes_.get(i));
    }
    for (int i = 0; i < runnables_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, runnables_.get(i));
    }
    for (int i = 0; i < lifecyclePolicies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, lifecyclePolicies_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEnvironment());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.TaskSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.TaskSpec other = (com.google.cloud.batch.v1.TaskSpec) obj;

    if (!getRunnablesList().equals(other.getRunnablesList())) return false;
    if (hasComputeResource() != other.hasComputeResource()) return false;
    if (hasComputeResource()) {
      if (!getComputeResource().equals(other.getComputeResource())) return false;
    }
    if (hasMaxRunDuration() != other.hasMaxRunDuration()) return false;
    if (hasMaxRunDuration()) {
      if (!getMaxRunDuration().equals(other.getMaxRunDuration())) return false;
    }
    if (getMaxRetryCount() != other.getMaxRetryCount()) return false;
    if (!getLifecyclePoliciesList().equals(other.getLifecyclePoliciesList())) return false;
    if (!internalGetEnvironments().equals(other.internalGetEnvironments())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (hasEnvironment() != other.hasEnvironment()) return false;
    if (hasEnvironment()) {
      if (!getEnvironment().equals(other.getEnvironment())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRunnablesCount() > 0) {
      hash = (37 * hash) + RUNNABLES_FIELD_NUMBER;
      hash = (53 * hash) + getRunnablesList().hashCode();
    }
    if (hasComputeResource()) {
      hash = (37 * hash) + COMPUTE_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getComputeResource().hashCode();
    }
    if (hasMaxRunDuration()) {
      hash = (37 * hash) + MAX_RUN_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxRunDuration().hashCode();
    }
    hash = (37 * hash) + MAX_RETRY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxRetryCount();
    if (getLifecyclePoliciesCount() > 0) {
      hash = (37 * hash) + LIFECYCLE_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getLifecyclePoliciesList().hashCode();
    }
    if (!internalGetEnvironments().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironments().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    if (hasEnvironment()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironment().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.TaskSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Spec of a task
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.TaskSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.TaskSpec)
      com.google.cloud.batch.v1.TaskSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_TaskSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetEnvironments();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableEnvironments();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_TaskSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.TaskSpec.class,
              com.google.cloud.batch.v1.TaskSpec.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.TaskSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRunnablesFieldBuilder();
        getComputeResourceFieldBuilder();
        getMaxRunDurationFieldBuilder();
        getLifecyclePoliciesFieldBuilder();
        getVolumesFieldBuilder();
        getEnvironmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (runnablesBuilder_ == null) {
        runnables_ = java.util.Collections.emptyList();
      } else {
        runnables_ = null;
        runnablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      computeResource_ = null;
      if (computeResourceBuilder_ != null) {
        computeResourceBuilder_.dispose();
        computeResourceBuilder_ = null;
      }
      maxRunDuration_ = null;
      if (maxRunDurationBuilder_ != null) {
        maxRunDurationBuilder_.dispose();
        maxRunDurationBuilder_ = null;
      }
      maxRetryCount_ = 0;
      if (lifecyclePoliciesBuilder_ == null) {
        lifecyclePolicies_ = java.util.Collections.emptyList();
      } else {
        lifecyclePolicies_ = null;
        lifecyclePoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableEnvironments().clear();
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_TaskSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskSpec getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.TaskSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskSpec build() {
      com.google.cloud.batch.v1.TaskSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskSpec buildPartial() {
      com.google.cloud.batch.v1.TaskSpec result = new com.google.cloud.batch.v1.TaskSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.batch.v1.TaskSpec result) {
      if (runnablesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          runnables_ = java.util.Collections.unmodifiableList(runnables_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.runnables_ = runnables_;
      } else {
        result.runnables_ = runnablesBuilder_.build();
      }
      if (lifecyclePoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          lifecyclePolicies_ = java.util.Collections.unmodifiableList(lifecyclePolicies_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.lifecyclePolicies_ = lifecyclePolicies_;
      } else {
        result.lifecyclePolicies_ = lifecyclePoliciesBuilder_.build();
      }
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.batch.v1.TaskSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.computeResource_ =
            computeResourceBuilder_ == null ? computeResource_ : computeResourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxRunDuration_ =
            maxRunDurationBuilder_ == null ? maxRunDuration_ : maxRunDurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxRetryCount_ = maxRetryCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.environments_ = internalGetEnvironments();
        result.environments_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.environment_ =
            environmentBuilder_ == null ? environment_ : environmentBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.TaskSpec) {
        return mergeFrom((com.google.cloud.batch.v1.TaskSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.TaskSpec other) {
      if (other == com.google.cloud.batch.v1.TaskSpec.getDefaultInstance()) return this;
      if (runnablesBuilder_ == null) {
        if (!other.runnables_.isEmpty()) {
          if (runnables_.isEmpty()) {
            runnables_ = other.runnables_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRunnablesIsMutable();
            runnables_.addAll(other.runnables_);
          }
          onChanged();
        }
      } else {
        if (!other.runnables_.isEmpty()) {
          if (runnablesBuilder_.isEmpty()) {
            runnablesBuilder_.dispose();
            runnablesBuilder_ = null;
            runnables_ = other.runnables_;
            bitField0_ = (bitField0_ & ~0x00000001);
            runnablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRunnablesFieldBuilder()
                    : null;
          } else {
            runnablesBuilder_.addAllMessages(other.runnables_);
          }
        }
      }
      if (other.hasComputeResource()) {
        mergeComputeResource(other.getComputeResource());
      }
      if (other.hasMaxRunDuration()) {
        mergeMaxRunDuration(other.getMaxRunDuration());
      }
      if (other.getMaxRetryCount() != 0) {
        setMaxRetryCount(other.getMaxRetryCount());
      }
      if (lifecyclePoliciesBuilder_ == null) {
        if (!other.lifecyclePolicies_.isEmpty()) {
          if (lifecyclePolicies_.isEmpty()) {
            lifecyclePolicies_ = other.lifecyclePolicies_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureLifecyclePoliciesIsMutable();
            lifecyclePolicies_.addAll(other.lifecyclePolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.lifecyclePolicies_.isEmpty()) {
          if (lifecyclePoliciesBuilder_.isEmpty()) {
            lifecyclePoliciesBuilder_.dispose();
            lifecyclePoliciesBuilder_ = null;
            lifecyclePolicies_ = other.lifecyclePolicies_;
            bitField0_ = (bitField0_ & ~0x00000010);
            lifecyclePoliciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLifecyclePoliciesFieldBuilder()
                    : null;
          } else {
            lifecyclePoliciesBuilder_.addAllMessages(other.lifecyclePolicies_);
          }
        }
      }
      internalGetMutableEnvironments().mergeFrom(other.internalGetEnvironments());
      bitField0_ |= 0x00000020;
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000040);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (other.hasEnvironment()) {
        mergeEnvironment(other.getEnvironment());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(getComputeResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMaxRunDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 40:
              {
                maxRetryCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environments__ =
                    input.readMessage(
                        EnvironmentsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableEnvironments()
                    .getMutableMap()
                    .put(environments__.getKey(), environments__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.batch.v1.Volume m =
                    input.readMessage(com.google.cloud.batch.v1.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.batch.v1.Runnable m =
                    input.readMessage(
                        com.google.cloud.batch.v1.Runnable.parser(), extensionRegistry);
                if (runnablesBuilder_ == null) {
                  ensureRunnablesIsMutable();
                  runnables_.add(m);
                } else {
                  runnablesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.batch.v1.LifecyclePolicy m =
                    input.readMessage(
                        com.google.cloud.batch.v1.LifecyclePolicy.parser(), extensionRegistry);
                if (lifecyclePoliciesBuilder_ == null) {
                  ensureLifecyclePoliciesIsMutable();
                  lifecyclePolicies_.add(m);
                } else {
                  lifecyclePoliciesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getEnvironmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.batch.v1.Runnable> runnables_ =
        java.util.Collections.emptyList();

    private void ensureRunnablesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        runnables_ = new java.util.ArrayList<com.google.cloud.batch.v1.Runnable>(runnables_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Runnable,
            com.google.cloud.batch.v1.Runnable.Builder,
            com.google.cloud.batch.v1.RunnableOrBuilder>
        runnablesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Runnable> getRunnablesList() {
      if (runnablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(runnables_);
      } else {
        return runnablesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public int getRunnablesCount() {
      if (runnablesBuilder_ == null) {
        return runnables_.size();
      } else {
        return runnablesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public com.google.cloud.batch.v1.Runnable getRunnables(int index) {
      if (runnablesBuilder_ == null) {
        return runnables_.get(index);
      } else {
        return runnablesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder setRunnables(int index, com.google.cloud.batch.v1.Runnable value) {
      if (runnablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRunnablesIsMutable();
        runnables_.set(index, value);
        onChanged();
      } else {
        runnablesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder setRunnables(
        int index, com.google.cloud.batch.v1.Runnable.Builder builderForValue) {
      if (runnablesBuilder_ == null) {
        ensureRunnablesIsMutable();
        runnables_.set(index, builderForValue.build());
        onChanged();
      } else {
        runnablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder addRunnables(com.google.cloud.batch.v1.Runnable value) {
      if (runnablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRunnablesIsMutable();
        runnables_.add(value);
        onChanged();
      } else {
        runnablesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder addRunnables(int index, com.google.cloud.batch.v1.Runnable value) {
      if (runnablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRunnablesIsMutable();
        runnables_.add(index, value);
        onChanged();
      } else {
        runnablesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder addRunnables(com.google.cloud.batch.v1.Runnable.Builder builderForValue) {
      if (runnablesBuilder_ == null) {
        ensureRunnablesIsMutable();
        runnables_.add(builderForValue.build());
        onChanged();
      } else {
        runnablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder addRunnables(
        int index, com.google.cloud.batch.v1.Runnable.Builder builderForValue) {
      if (runnablesBuilder_ == null) {
        ensureRunnablesIsMutable();
        runnables_.add(index, builderForValue.build());
        onChanged();
      } else {
        runnablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder addAllRunnables(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.Runnable> values) {
      if (runnablesBuilder_ == null) {
        ensureRunnablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, runnables_);
        onChanged();
      } else {
        runnablesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder clearRunnables() {
      if (runnablesBuilder_ == null) {
        runnables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        runnablesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public Builder removeRunnables(int index) {
      if (runnablesBuilder_ == null) {
        ensureRunnablesIsMutable();
        runnables_.remove(index);
        onChanged();
      } else {
        runnablesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public com.google.cloud.batch.v1.Runnable.Builder getRunnablesBuilder(int index) {
      return getRunnablesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public com.google.cloud.batch.v1.RunnableOrBuilder getRunnablesOrBuilder(int index) {
      if (runnablesBuilder_ == null) {
        return runnables_.get(index);
      } else {
        return runnablesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.RunnableOrBuilder>
        getRunnablesOrBuilderList() {
      if (runnablesBuilder_ != null) {
        return runnablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(runnables_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public com.google.cloud.batch.v1.Runnable.Builder addRunnablesBuilder() {
      return getRunnablesFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.Runnable.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public com.google.cloud.batch.v1.Runnable.Builder addRunnablesBuilder(int index) {
      return getRunnablesFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.Runnable.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The sequence of one or more runnables (executable scripts,
     * executable containers, and/or barriers) for each task in this task group to
     * run. Each task runs this list of runnables in order. For a task to succeed,
     * all of its script and container runnables each must meet at least one of
     * the following conditions:
     *
     * + The runnable exited with a zero status.
     * + The runnable didn't finish, but you enabled its `background` subfield.
     * + The runnable exited with a non-zero status, but you enabled its
     *   `ignore_exit_status` subfield.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Runnable runnables = 8;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Runnable.Builder> getRunnablesBuilderList() {
      return getRunnablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Runnable,
            com.google.cloud.batch.v1.Runnable.Builder,
            com.google.cloud.batch.v1.RunnableOrBuilder>
        getRunnablesFieldBuilder() {
      if (runnablesBuilder_ == null) {
        runnablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.Runnable,
                com.google.cloud.batch.v1.Runnable.Builder,
                com.google.cloud.batch.v1.RunnableOrBuilder>(
                runnables_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        runnables_ = null;
      }
      return runnablesBuilder_;
    }

    private com.google.cloud.batch.v1.ComputeResource computeResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.ComputeResource,
            com.google.cloud.batch.v1.ComputeResource.Builder,
            com.google.cloud.batch.v1.ComputeResourceOrBuilder>
        computeResourceBuilder_;

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     *
     * @return Whether the computeResource field is set.
     */
    public boolean hasComputeResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     *
     * @return The computeResource.
     */
    public com.google.cloud.batch.v1.ComputeResource getComputeResource() {
      if (computeResourceBuilder_ == null) {
        return computeResource_ == null
            ? com.google.cloud.batch.v1.ComputeResource.getDefaultInstance()
            : computeResource_;
      } else {
        return computeResourceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public Builder setComputeResource(com.google.cloud.batch.v1.ComputeResource value) {
      if (computeResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        computeResource_ = value;
      } else {
        computeResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public Builder setComputeResource(
        com.google.cloud.batch.v1.ComputeResource.Builder builderForValue) {
      if (computeResourceBuilder_ == null) {
        computeResource_ = builderForValue.build();
      } else {
        computeResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public Builder mergeComputeResource(com.google.cloud.batch.v1.ComputeResource value) {
      if (computeResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && computeResource_ != null
            && computeResource_ != com.google.cloud.batch.v1.ComputeResource.getDefaultInstance()) {
          getComputeResourceBuilder().mergeFrom(value);
        } else {
          computeResource_ = value;
        }
      } else {
        computeResourceBuilder_.mergeFrom(value);
      }
      if (computeResource_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public Builder clearComputeResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      computeResource_ = null;
      if (computeResourceBuilder_ != null) {
        computeResourceBuilder_.dispose();
        computeResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public com.google.cloud.batch.v1.ComputeResource.Builder getComputeResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getComputeResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    public com.google.cloud.batch.v1.ComputeResourceOrBuilder getComputeResourceOrBuilder() {
      if (computeResourceBuilder_ != null) {
        return computeResourceBuilder_.getMessageOrBuilder();
      } else {
        return computeResource_ == null
            ? com.google.cloud.batch.v1.ComputeResource.getDefaultInstance()
            : computeResource_;
      }
    }

    /**
     *
     *
     * <pre>
     * ComputeResource requirements.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.ComputeResource compute_resource = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.ComputeResource,
            com.google.cloud.batch.v1.ComputeResource.Builder,
            com.google.cloud.batch.v1.ComputeResourceOrBuilder>
        getComputeResourceFieldBuilder() {
      if (computeResourceBuilder_ == null) {
        computeResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.ComputeResource,
                com.google.cloud.batch.v1.ComputeResource.Builder,
                com.google.cloud.batch.v1.ComputeResourceOrBuilder>(
                getComputeResource(), getParentForChildren(), isClean());
        computeResource_ = null;
      }
      return computeResourceBuilder_;
    }

    private com.google.protobuf.Duration maxRunDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxRunDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     *
     * @return Whether the maxRunDuration field is set.
     */
    public boolean hasMaxRunDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     *
     * @return The maxRunDuration.
     */
    public com.google.protobuf.Duration getMaxRunDuration() {
      if (maxRunDurationBuilder_ == null) {
        return maxRunDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRunDuration_;
      } else {
        return maxRunDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public Builder setMaxRunDuration(com.google.protobuf.Duration value) {
      if (maxRunDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxRunDuration_ = value;
      } else {
        maxRunDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public Builder setMaxRunDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxRunDurationBuilder_ == null) {
        maxRunDuration_ = builderForValue.build();
      } else {
        maxRunDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public Builder mergeMaxRunDuration(com.google.protobuf.Duration value) {
      if (maxRunDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && maxRunDuration_ != null
            && maxRunDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaxRunDurationBuilder().mergeFrom(value);
        } else {
          maxRunDuration_ = value;
        }
      } else {
        maxRunDurationBuilder_.mergeFrom(value);
      }
      if (maxRunDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public Builder clearMaxRunDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxRunDuration_ = null;
      if (maxRunDurationBuilder_ != null) {
        maxRunDurationBuilder_.dispose();
        maxRunDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxRunDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaxRunDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxRunDurationOrBuilder() {
      if (maxRunDurationBuilder_ != null) {
        return maxRunDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxRunDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRunDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Maximum duration the task should run before being automatically retried
     * (if enabled) or automatically failed. Format the value of this field
     * as a time limit in seconds followed by `s`&amp;mdash;for example, `3600s`
     * for 1 hour. The field accepts any value between 0 and the maximum listed
     * for the `Duration` field type at
     * https://protobuf.dev/reference/protobuf/google.protobuf/#duration; however,
     * the actual maximum run time for a job will be limited to the maximum run
     * time for a job listed at
     * https://cloud.google.com/batch/quotas#max-job-duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_run_duration = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxRunDurationFieldBuilder() {
      if (maxRunDurationBuilder_ == null) {
        maxRunDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxRunDuration(), getParentForChildren(), isClean());
        maxRunDuration_ = null;
      }
      return maxRunDurationBuilder_;
    }

    private int maxRetryCount_;

    /**
     *
     *
     * <pre>
     * Maximum number of retries on failures.
     * The default, 0, which means never retry.
     * The valid value range is [0, 10].
     * </pre>
     *
     * <code>int32 max_retry_count = 5;</code>
     *
     * @return The maxRetryCount.
     */
    @java.lang.Override
    public int getMaxRetryCount() {
      return maxRetryCount_;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of retries on failures.
     * The default, 0, which means never retry.
     * The valid value range is [0, 10].
     * </pre>
     *
     * <code>int32 max_retry_count = 5;</code>
     *
     * @param value The maxRetryCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRetryCount(int value) {

      maxRetryCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of retries on failures.
     * The default, 0, which means never retry.
     * The valid value range is [0, 10].
     * </pre>
     *
     * <code>int32 max_retry_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRetryCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxRetryCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1.LifecyclePolicy> lifecyclePolicies_ =
        java.util.Collections.emptyList();

    private void ensureLifecyclePoliciesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        lifecyclePolicies_ =
            new java.util.ArrayList<com.google.cloud.batch.v1.LifecyclePolicy>(lifecyclePolicies_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.LifecyclePolicy,
            com.google.cloud.batch.v1.LifecyclePolicy.Builder,
            com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>
        lifecyclePoliciesBuilder_;

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.LifecyclePolicy> getLifecyclePoliciesList() {
      if (lifecyclePoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(lifecyclePolicies_);
      } else {
        return lifecyclePoliciesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public int getLifecyclePoliciesCount() {
      if (lifecyclePoliciesBuilder_ == null) {
        return lifecyclePolicies_.size();
      } else {
        return lifecyclePoliciesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy getLifecyclePolicies(int index) {
      if (lifecyclePoliciesBuilder_ == null) {
        return lifecyclePolicies_.get(index);
      } else {
        return lifecyclePoliciesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder setLifecyclePolicies(
        int index, com.google.cloud.batch.v1.LifecyclePolicy value) {
      if (lifecyclePoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.set(index, value);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder setLifecyclePolicies(
        int index, com.google.cloud.batch.v1.LifecyclePolicy.Builder builderForValue) {
      if (lifecyclePoliciesBuilder_ == null) {
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder addLifecyclePolicies(com.google.cloud.batch.v1.LifecyclePolicy value) {
      if (lifecyclePoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.add(value);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder addLifecyclePolicies(
        int index, com.google.cloud.batch.v1.LifecyclePolicy value) {
      if (lifecyclePoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.add(index, value);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder addLifecyclePolicies(
        com.google.cloud.batch.v1.LifecyclePolicy.Builder builderForValue) {
      if (lifecyclePoliciesBuilder_ == null) {
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.add(builderForValue.build());
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder addLifecyclePolicies(
        int index, com.google.cloud.batch.v1.LifecyclePolicy.Builder builderForValue) {
      if (lifecyclePoliciesBuilder_ == null) {
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder addAllLifecyclePolicies(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.LifecyclePolicy> values) {
      if (lifecyclePoliciesBuilder_ == null) {
        ensureLifecyclePoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lifecyclePolicies_);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder clearLifecyclePolicies() {
      if (lifecyclePoliciesBuilder_ == null) {
        lifecyclePolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public Builder removeLifecyclePolicies(int index) {
      if (lifecyclePoliciesBuilder_ == null) {
        ensureLifecyclePoliciesIsMutable();
        lifecyclePolicies_.remove(index);
        onChanged();
      } else {
        lifecyclePoliciesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.Builder getLifecyclePoliciesBuilder(
        int index) {
      return getLifecyclePoliciesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicyOrBuilder getLifecyclePoliciesOrBuilder(
        int index) {
      if (lifecyclePoliciesBuilder_ == null) {
        return lifecyclePolicies_.get(index);
      } else {
        return lifecyclePoliciesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>
        getLifecyclePoliciesOrBuilderList() {
      if (lifecyclePoliciesBuilder_ != null) {
        return lifecyclePoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(lifecyclePolicies_);
      }
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.Builder addLifecyclePoliciesBuilder() {
      return getLifecyclePoliciesFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.LifecyclePolicy.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.Builder addLifecyclePoliciesBuilder(
        int index) {
      return getLifecyclePoliciesFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.LifecyclePolicy.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Lifecycle management schema when any task in a task group is failed.
     * Currently we only support one lifecycle policy.
     * When the lifecycle policy condition is met,
     * the action in the policy will execute.
     * If task execution result does not meet with the defined lifecycle
     * policy, we consider it as the default policy.
     * Default policy means if the exit code is 0, exit task.
     * If task ends with non-zero exit code, retry the task with max_retry_count.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.LifecyclePolicy lifecycle_policies = 9;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.LifecyclePolicy.Builder>
        getLifecyclePoliciesBuilderList() {
      return getLifecyclePoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.LifecyclePolicy,
            com.google.cloud.batch.v1.LifecyclePolicy.Builder,
            com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>
        getLifecyclePoliciesFieldBuilder() {
      if (lifecyclePoliciesBuilder_ == null) {
        lifecyclePoliciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.LifecyclePolicy,
                com.google.cloud.batch.v1.LifecyclePolicy.Builder,
                com.google.cloud.batch.v1.LifecyclePolicyOrBuilder>(
                lifecyclePolicies_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        lifecyclePolicies_ = null;
      }
      return lifecyclePoliciesBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environments_;

    @java.lang.Deprecated
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironments() {
      if (environments_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentsDefaultEntryHolder.defaultEntry);
      }
      return environments_;
    }

    @java.lang.Deprecated
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironments() {
      if (environments_ == null) {
        environments_ =
            com.google.protobuf.MapField.newMapField(EnvironmentsDefaultEntryHolder.defaultEntry);
      }
      if (!environments_.isMutable()) {
        environments_ = environments_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return environments_;
    }

    @java.lang.Deprecated
    public int getEnvironmentsCount() {
      return internalGetEnvironments().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsEnvironments(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironments().getMap().containsKey(key);
    }

    /** Use {@link #getEnvironmentsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironments() {
      return getEnvironmentsMap();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentsMap() {
      return internalGetEnvironments().getMap();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public /* nullable */ java.lang.String getEnvironmentsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironments().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getEnvironmentsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironments().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    @java.lang.Deprecated
    public Builder clearEnvironments() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableEnvironments().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder removeEnvironments(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironments().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironments() {
      bitField0_ |= 0x00000020;
      return internalGetMutableEnvironments().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putEnvironments(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvironments().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use environment(non-plural) instead.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environments = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putAllEnvironments(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironments().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloud.batch.v1.Volume>(volumes_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Volume,
            com.google.cloud.batch.v1.Volume.Builder,
            com.google.cloud.batch.v1.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public com.google.cloud.batch.v1.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.batch.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.batch.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder addVolumes(com.google.cloud.batch.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.batch.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder addVolumes(com.google.cloud.batch.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.batch.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public com.google.cloud.batch.v1.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public com.google.cloud.batch.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public com.google.cloud.batch.v1.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.Volume.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public com.google.cloud.batch.v1.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.Volume.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount before running Tasks using this TaskSpec.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Volume volumes = 7;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Volume,
            com.google.cloud.batch.v1.Volume.Builder,
            com.google.cloud.batch.v1.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.Volume,
                com.google.cloud.batch.v1.Volume.Builder,
                com.google.cloud.batch.v1.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    private com.google.cloud.batch.v1.Environment environment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.Environment,
            com.google.cloud.batch.v1.Environment.Builder,
            com.google.cloud.batch.v1.EnvironmentOrBuilder>
        environmentBuilder_;

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     *
     * @return Whether the environment field is set.
     */
    public boolean hasEnvironment() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     *
     * @return The environment.
     */
    public com.google.cloud.batch.v1.Environment getEnvironment() {
      if (environmentBuilder_ == null) {
        return environment_ == null
            ? com.google.cloud.batch.v1.Environment.getDefaultInstance()
            : environment_;
      } else {
        return environmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public Builder setEnvironment(com.google.cloud.batch.v1.Environment value) {
      if (environmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
      } else {
        environmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public Builder setEnvironment(com.google.cloud.batch.v1.Environment.Builder builderForValue) {
      if (environmentBuilder_ == null) {
        environment_ = builderForValue.build();
      } else {
        environmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public Builder mergeEnvironment(com.google.cloud.batch.v1.Environment value) {
      if (environmentBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && environment_ != null
            && environment_ != com.google.cloud.batch.v1.Environment.getDefaultInstance()) {
          getEnvironmentBuilder().mergeFrom(value);
        } else {
          environment_ = value;
        }
      } else {
        environmentBuilder_.mergeFrom(value);
      }
      if (environment_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public Builder clearEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000080);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public com.google.cloud.batch.v1.Environment.Builder getEnvironmentBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEnvironmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    public com.google.cloud.batch.v1.EnvironmentOrBuilder getEnvironmentOrBuilder() {
      if (environmentBuilder_ != null) {
        return environmentBuilder_.getMessageOrBuilder();
      } else {
        return environment_ == null
            ? com.google.cloud.batch.v1.Environment.getDefaultInstance()
            : environment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to set before running the Task.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment environment = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.Environment,
            com.google.cloud.batch.v1.Environment.Builder,
            com.google.cloud.batch.v1.EnvironmentOrBuilder>
        getEnvironmentFieldBuilder() {
      if (environmentBuilder_ == null) {
        environmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.Environment,
                com.google.cloud.batch.v1.Environment.Builder,
                com.google.cloud.batch.v1.EnvironmentOrBuilder>(
                getEnvironment(), getParentForChildren(), isClean());
        environment_ = null;
      }
      return environmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.TaskSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.TaskSpec)
  private static final com.google.cloud.batch.v1.TaskSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.TaskSpec();
  }

  public static com.google.cloud.batch.v1.TaskSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TaskSpec> PARSER =
      new com.google.protobuf.AbstractParser<TaskSpec>() {
        @java.lang.Override
        public TaskSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TaskSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TaskSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.TaskSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
