/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.FileCopyUtils;

public class AsymmetricCryptography {
    private static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----";
    private static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final String PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";
    private final ResourceLoader resourceLoader;

    public AsymmetricCryptography(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private byte[] getResourceBytes(Resource resource) {
        return FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
    }

    private byte[] decodePem(byte[] bytes, String ... headers) {
        String pem = new String(bytes, StandardCharsets.UTF_8);
        for (String header : headers) {
            pem = pem.replace(header, "");
        }
        return Base64.getMimeDecoder().decode(pem);
    }

    public PrivateKey getPrivateKey(String resourceLocation, KeyFormat format) {
        return this.getPrivateKey(this.resourceLoader.getResource(resourceLocation), format);
    }

    public PrivateKey getPrivateKey(Resource resource, KeyFormat format) {
        byte[] keyBytes = this.getResourceBytes(resource);
        if (format == KeyFormat.PEM) {
            keyBytes = this.decodePem(keyBytes, PRIVATE_KEY_HEADER, PRIVATE_KEY_FOOTER);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    public PublicKey getPublicKey(String resourceLocation, KeyFormat format) {
        return this.getPublicKey(this.resourceLoader.getResource(resourceLocation), format);
    }

    public PublicKey getPublicKey(Resource resource, KeyFormat format) {
        byte[] keyBytes = this.getResourceBytes(resource);
        if (format == KeyFormat.PEM) {
            keyBytes = this.decodePem(keyBytes, PUBLIC_KEY_HEADER, PUBLIC_KEY_FOOTER);
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    public byte[] encrypt(byte[] msg, PublicKey key) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, key);
        return cipher.doFinal(msg);
    }

    public byte[] decrypt(byte[] msg, PrivateKey key) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, key);
        return cipher.doFinal(msg);
    }

    public static enum KeyFormat {
        DER,
        PEM;

    }
}

