/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.environment.EnvironmentInitializer;
import java.util.List;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class StandardEncryptableEnvironment
extends StandardEnvironment
implements ConfigurableEnvironment {
    private MutablePropertySources encryptablePropertySources;
    private MutablePropertySources originalPropertySources;

    public StandardEncryptableEnvironment() {
        this(null, null, null, null, null, null);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, List<Class<PropertySource<?>>> skipPropertySourceClasses, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        EnvironmentInitializer initializer = new EnvironmentInitializer(this, interceptionMode, skipPropertySourceClasses, resolver, filter, encryptor, detector);
        this.encryptablePropertySources = initializer.initialize(this.originalPropertySources);
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
        super.customizePropertySources(propertySources);
        this.originalPropertySources = propertySources;
    }

    public MutablePropertySources getPropertySources() {
        return this.encryptablePropertySources;
    }

    public static StandardEncryptableEnvironmentBuilder builder() {
        return new StandardEncryptableEnvironmentBuilder();
    }

    public static class StandardEncryptableEnvironmentBuilder {
        private InterceptionMode interceptionMode;
        private List<Class<PropertySource<?>>> skipPropertySourceClasses;
        private EncryptablePropertyResolver resolver;
        private EncryptablePropertyFilter filter;
        private StringEncryptor encryptor;
        private EncryptablePropertyDetector detector;

        StandardEncryptableEnvironmentBuilder() {
        }

        public StandardEncryptableEnvironmentBuilder interceptionMode(InterceptionMode interceptionMode) {
            this.interceptionMode = interceptionMode;
            return this;
        }

        public StandardEncryptableEnvironmentBuilder skipPropertySourceClasses(List<Class<PropertySource<?>>> skipPropertySourceClasses) {
            this.skipPropertySourceClasses = skipPropertySourceClasses;
            return this;
        }

        public StandardEncryptableEnvironmentBuilder resolver(EncryptablePropertyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public StandardEncryptableEnvironmentBuilder filter(EncryptablePropertyFilter filter) {
            this.filter = filter;
            return this;
        }

        public StandardEncryptableEnvironmentBuilder encryptor(StringEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public StandardEncryptableEnvironmentBuilder detector(EncryptablePropertyDetector detector) {
            this.detector = detector;
            return this;
        }

        public StandardEncryptableEnvironment build() {
            return new StandardEncryptableEnvironment(this.interceptionMode, this.skipPropertySourceClasses, this.resolver, this.filter, this.encryptor, this.detector);
        }

        public String toString() {
            return "StandardEncryptableEnvironment.StandardEncryptableEnvironmentBuilder(interceptionMode=" + (Object)((Object)this.interceptionMode) + ", skipPropertySourceClasses=" + this.skipPropertySourceClasses + ", resolver=" + this.resolver + ", filter=" + this.filter + ", encryptor=" + this.encryptor + ", detector=" + this.detector + ")";
        }
    }
}

