/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

final class InternalUtil {
    private static final char CARET = '^';
    private static final char SPACE = ' ';

    private InternalUtil() {
    }

    public static void assertParamNotNull(String paramName, Object value) {
        if (value == null) {
            throw new NullPointerException(paramName + " should not be null");
        }
    }

    public static String buildCaretLine(String message, int column, int rangeLen) {
        StringBuilder builder = new StringBuilder();
        InternalUtil.repeatChar(builder, ' ', column);
        InternalUtil.repeatChar(builder, '^', Integer.max(rangeLen, 1));
        return builder.append(' ').append(message).toString();
    }

    private static void repeatChar(StringBuilder builder, char c, int n) {
        int start = builder.length();
        while (n > 0) {
            int lenAdded = builder.length() - start;
            if (n >= lenAdded && lenAdded > 0) {
                builder.append(builder, start, builder.length());
                n -= lenAdded;
                continue;
            }
            builder.append(c);
            --n;
        }
    }
}

