/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.internal.grid.CollectionGridDataSource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.TranslatorSource;
import org.got5.tapestry5.jquery.internal.DataTableModel;

public class DefaultDataTableModel
implements DataTableModel {
    private TypeCoercer typeCoercer;
    private Request request;
    private GridSortModel sortModel;
    private BeanModel model;
    private PropertyOverrides overrides;
    private TranslatorSource translatorSource;
    private JSONObject response = new JSONObject();

    public DefaultDataTableModel(TypeCoercer typeCoercer, TranslatorSource translatorSource) {
        this.typeCoercer = typeCoercer;
        this.translatorSource = translatorSource;
    }

    public GridDataSource filterData(GridDataSource source) {
        final ArrayList<Object> datas = new ArrayList<Object>();
        for (int index = 0; index < source.getAvailableRows(); ++index) {
            boolean flag = false;
            for (Object name : this.model.getPropertyNames()) {
                PropertyConduit conduit = this.model.get((String)name).getConduit();
                Class type = conduit.getPropertyType();
                try {
                    String val = (String)conduit.get(source.getRowValue(index));
                    if (!val.contains(this.request.getParameter("sSearch"))) continue;
                    flag = true;
                }
                catch (Exception e) {}
            }
            if (!flag) continue;
            datas.add(source.getRowValue(index));
        }
        return new GridDataSource(){
            private CollectionGridDataSource cgds;
            {
                this.cgds = new CollectionGridDataSource((Collection)datas);
            }

            public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
                this.cgds.prepare(startIndex, endIndex, sortConstraints);
            }

            public Object getRowValue(int index) {
                return this.cgds.getRowValue(index);
            }

            public Class getRowType() {
                return this.cgds.getRowType();
            }

            public int getAvailableRows() {
                return this.cgds.getAvailableRows();
            }
        };
    }

    public void prepareResponse(GridDataSource source) {
        String sortingCols = this.request.getParameter("iSortingCols");
        int nbSortingCols = Integer.parseInt(sortingCols);
        String sord = this.request.getParameter("sSortDir_0");
        String sidx = this.request.getParameter("iSortCol_0");
        if (nbSortingCols > 0) {
            List names = this.model.getPropertyNames();
            int indexProperty = Integer.parseInt(sidx);
            String propName = (String)names.get(indexProperty);
            ColumnSort colSort = this.sortModel.getColumnSort(propName);
            this.sortModel.updateSort(propName);
        }
    }

    public JSONObject getResponse(GridDataSource source) {
        this.response.put("sEcho", (Object)this.request.getParameter("sEcho"));
        int records = source.getAvailableRows();
        this.response.put("iTotalDisplayRecords", (Object)records);
        this.response.put("iTotalRecords", (Object)records);
        String displayStart = this.request.getParameter("iDisplayStart");
        int startIndex = Integer.parseInt(displayStart);
        String displayLength = this.request.getParameter("iDisplayLength");
        int rowsPerPage = Integer.parseInt(displayLength);
        int endIndex = startIndex + rowsPerPage - 1;
        if (endIndex > records - 1) {
            endIndex = records - 1;
        }
        source.prepare(startIndex, endIndex, this.sortModel.getSortConstraints());
        JSONArray rows = new JSONArray();
        for (int index = startIndex; index <= endIndex; ++index) {
            JSONArray cell = new JSONArray();
            Object obj = source.getRowValue(index);
            List names = this.model.getPropertyNames();
            for (String name : names) {
                PropertyConduit conduit = this.model.get(name).getConduit();
                Class type = conduit.getPropertyType();
                Object val = conduit.get(obj);
                if (!String.class.equals(this.model.get(name).getClass()) && !Number.class.isAssignableFrom(this.model.get(name).getClass())) {
                    Translator translator = this.translatorSource.findByType(this.model.get(name).getPropertyType());
                    val = translator != null ? translator.toClient(val) : (val != null ? val.toString() : "");
                }
                cell.put(val);
            }
            rows.put((Object)cell);
        }
        this.response.put("aaData", (Object)rows);
        return this.response;
    }

    public JSONObject sendResponse(Request request, GridDataSource source, BeanModel model, GridSortModel sortModel, PropertyOverrides overrides) {
        this.request = request;
        this.sortModel = sortModel;
        this.model = model;
        this.overrides = overrides;
        GridDataSource s = source;
        if (InternalUtils.isNonBlank((String)request.getParameter("sSearch"))) {
            s = this.filterData(source);
        }
        this.prepareResponse(s);
        return this.getResponse(s);
    }
}

