/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import com.github.kongchen.swagger.docgen.jaxrs.JaxrsParameterExtension;
import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.core.header.FormDataContentDisposition;
import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.reflections.util.Utils;

public class BeanParamInjectParamExtention
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        ArrayList<Parameter> output = new ArrayList<Parameter>();
        if (this.shouldIgnoreClass(cls) || typesToSkip.contains(type)) {
            typesToSkip.add(type);
            return output;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof BeanParam) && !(annotation instanceof InjectParam)) continue;
            return this.extractParameters(cls);
        }
        if (chain.hasNext()) {
            return chain.next().extractParameters(annotations, type, typesToSkip, chain);
        }
        return null;
    }

    private List<Parameter> extractParameters(Class<?> cls) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Field f : cls.getDeclaredFields()) {
            Parameter parameter = null;
            int i = 0;
            int apiParaIdx = -1;
            for (Annotation annotation : f.getAnnotations()) {
                if (annotation instanceof ApiParam) {
                    apiParaIdx = i;
                }
                ++i;
                parameter = JaxrsParameterExtension.getParameter(cls, parameter, annotation);
            }
            if (parameter == null) continue;
            if (apiParaIdx != -1) {
                ApiParam param = (ApiParam)f.getAnnotations()[apiParaIdx];
                parameter.setDescription(param.value());
                parameter.setRequired(param.required());
                parameter.setAccess(param.access());
                if (!Utils.isEmpty((String)param.name())) {
                    parameter.setName(param.name());
                }
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = FormDataContentDisposition.class.equals(cls);
        return output;
    }
}

