/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.Position;
import com.github.jferard.fastods.util.TableNameUtil;

public class PositionBuilder {
    private final int column;
    private final EqualityUtil equalityUtil;
    private final TableNameUtil tableNameUtil;
    private final int row;
    private int status;
    private String tableName;
    private String fileName;

    PositionBuilder(EqualityUtil equalityUtil, TableNameUtil tableNameUtil, int row, int column) {
        this.equalityUtil = equalityUtil;
        this.tableNameUtil = tableNameUtil;
        this.fileName = null;
        this.tableName = null;
        this.row = row;
        this.column = column;
        this.status = 0;
    }

    public PositionBuilder absRow() {
        this.status |= 2;
        return this;
    }

    public PositionBuilder absCol() {
        this.status |= 1;
        return this;
    }

    public PositionBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public PositionBuilder absTableName(String tableName) {
        this.tableName = tableName;
        this.status |= 4;
        return this;
    }

    public PositionBuilder table(NamedObject table) {
        this.tableName = table.getName();
        return this;
    }

    public PositionBuilder absTable(NamedObject table) {
        this.tableName = table.getName();
        this.status |= 4;
        return this;
    }

    public PositionBuilder file(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public Position build() {
        return new Position(this.equalityUtil, this.tableNameUtil, this.fileName, this.tableName, this.row, this.column, this.status);
    }
}

