/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.style.BorderAttributeBuilder;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.SimpleLength;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class BorderAttribute {
    public static final Color DEFAULT_BORDER_COLOR = SimpleColor.BLACK;
    public static final Length DEFAULT_BORDER_SIZE = SimpleLength.mm(1.0);
    public static final Position DEFAULT_POSITION = Position.ALL;
    public static final Style DEFAULT_STYLE = Style.SOLID;
    private final Color borderColor;
    private final Length borderSize;
    private final Style style;

    public static BorderAttributeBuilder builder() {
        return new BorderAttributeBuilder();
    }

    BorderAttribute(Length size, Color color, Style style) {
        this.borderSize = size;
        this.borderColor = color;
        this.style = style;
    }

    private CharSequence toXMLAttributeValue() {
        StringBuilder sb = new StringBuilder();
        if (this.borderSize == null) {
            if (this.borderColor != SimpleColor.NONE) {
                sb.append(this.style.attrValue).append(' ').append(this.borderColor.hexValue());
            }
        } else if (this.borderColor == SimpleColor.NONE) {
            sb.append(this.borderSize);
        } else {
            sb.append(this.borderSize).append(' ').append(this.style.attrValue).append(' ').append(this.borderColor.hexValue());
        }
        return sb;
    }

    public String toString() {
        return "BorderAttribute[" + this.toXMLAttributeValue() + "]";
    }

    public void appendXMLAttribute(XMLUtil util, Appendable appendable, String attrName) throws IOException {
        util.appendAttribute(appendable, (CharSequence)attrName, this.toXMLAttributeValue());
    }

    public static enum Style {
        NONE("none"),
        HIDDEN("hidden"),
        DOTTED("dotted"),
        DASHED("dashed"),
        SOLID("solid"),
        DOUBLE("double"),
        GROOVE("groove"),
        RIDGE("ridge"),
        INSET("inset"),
        OUTSET("outset");

        private final String attrValue;

        private Style(String attrValue) {
            this.attrValue = attrValue;
        }

        String getAttrValue() {
            return this.attrValue;
        }
    }

    public static enum Position {
        ALL("fo:border"),
        BOTTOM("fo:border-bottom"),
        LEFT("fo:border-left"),
        RIGHT("fo:border-right"),
        TOP("fo:border-top");

        private final String attrName;

        private Position(String attrName) {
            this.attrName = attrName;
        }

        String getAttrName() {
            return this.attrName;
        }
    }
}

