/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.CoreDataStyle;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DateTimeStyleFormat;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TimeStyle
implements DataStyle {
    private final CoreDataStyle dataStyle;
    private final DateTimeStyleFormat timeFormat;

    TimeStyle(CoreDataStyle dataStyle, DateTimeStyleFormat timeFormat) {
        this.dataStyle = dataStyle;
        this.timeFormat = timeFormat;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<number:time-style");
        util.appendEAttribute(appendable, "style:name", this.dataStyle.getName());
        this.dataStyle.appendLVAttributes(util, appendable);
        if (this.timeFormat == null) {
            util.appendAttribute(appendable, (CharSequence)"number:format-source", "language");
            appendable.append("/>");
        } else {
            util.appendAttribute(appendable, (CharSequence)"number:format-source", "fixed");
            appendable.append(">");
            this.timeFormat.appendXMLContent(util, appendable);
            appendable.append("</number:time-style>");
        }
    }

    @Override
    public String getName() {
        return this.dataStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.dataStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }

    public static class Format {
        public static final DateTimeStyleFormat HHMMSS = new DateTimeStyleFormat("<number:hours number:style=\"long\"/>", "<number:text>:</number:text>", "<number:minutes number:style=\"long\"/>", "<number:text>:</number:text>", "<number:seconds number:style=\"long\"/>");
        public static final DateTimeStyleFormat HHMMSS00 = new DateTimeStyleFormat("<number:hours number:style=\"long\"/>", "<number:text>:</number:text>", "<number:minutes number:style=\"long\"/>", "<number:text>:</number:text>", DateTimeStyleFormat.longSeconds(2));
    }
}

