/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.NumberStyleHelper;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class FloatStyle
implements DataStyle {
    private final NumberStyleHelper numberStyle;
    private final int decimalPlaces;

    public FloatStyle(NumberStyleHelper numberStyle, int decimalPlaces) {
        this.numberStyle = numberStyle;
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        StringBuilder number = this.computeNumberTag(util);
        this.numberStyle.appendXMLHelper(util, appendable, "number-style", number);
    }

    StringBuilder computeNumberTag(XMLUtil util) throws IOException {
        StringBuilder number = new StringBuilder();
        this.appendNumberTag(util, number);
        return number;
    }

    public void appendNumberTag(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<number:number");
        this.appendXMLAttributes(util, appendable);
        appendable.append("/>");
    }

    void appendXMLAttributes(XMLUtil util, Appendable appendable) throws IOException {
        util.appendAttribute(appendable, (CharSequence)"number:decimal-places", this.decimalPlaces);
        this.numberStyle.appendNumberAttribute(util, appendable);
    }

    void appendXMLHelper(XMLUtil util, Appendable appendable, String numberStyleName, CharSequence number) throws IOException {
        this.numberStyle.appendXMLHelper(util, appendable, numberStyleName, number);
    }

    @Override
    public String getName() {
        return this.numberStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.numberStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }
}

