/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;

public class TimeValue
implements CellValue {
    private static final int MONTHS_BY_YEAR = 12;
    private static final int HOURS_BY_DAY = 24;
    private static final int MINUTES_BY_HOUR = 60;
    private static final int SECONDS_BY_MINUTE = 60;
    private final boolean neg;
    private final long years;
    private final long months;
    private final long days;
    private final long hours;
    private final long minutes;
    private final double seconds;

    public static TimeValue from(Object o) throws FastOdsException {
        if (o instanceof Number) {
            boolean neg;
            Number number = (Number)o;
            long l = number.longValue();
            boolean bl = neg = l < 0L;
            if (neg) {
                l = -l;
            }
            return new TimeValue(neg, 0L, 0L, 0L, 0L, 0L, (double)l / 1000.0);
        }
        if (o instanceof TimeValue) {
            return (TimeValue)o;
        }
        throw new FastOdsException("Can't cast " + o + " to Time");
    }

    public TimeValue(boolean neg, long years, long months, long days, long hours, long minutes, double seconds) {
        this.neg = neg;
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeValue)) {
            return false;
        }
        TimeValue other = (TimeValue)o;
        return this.neg == other.neg && this.totalMonths() == other.totalMonths() && Math.abs(this.totalSeconds() - other.totalSeconds()) < 1.0E-5;
    }

    private long totalMonths() {
        return this.years * 12L + this.months;
    }

    private double totalSeconds() {
        return (double)(((this.days * 24L + this.hours) * 60L + this.minutes) * 60L) + this.seconds;
    }

    public final int hashCode() {
        return (int)((double)(((long)(this.neg ? 31 : 0) + this.totalMonths()) * 31L) + this.totalSeconds());
    }

    @Override
    public void setToCell(TableCell tableCell) {
        if (this.neg) {
            tableCell.setNegTimeValue(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
        } else {
            tableCell.setTimeValue(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
        }
    }

    public String toString() {
        return "TimeValue[" + (this.neg ? "-P" : "P") + this.years + "Y" + this.months + "M" + this.days + "DT" + this.hours + "H" + this.minutes + "M" + this.seconds + "S]";
    }
}

