/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractGraphMojo;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;

abstract class AbstractDependencyGraphMojo
extends AbstractGraphMojo {
    @Deprecated
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="classpathScope")
    private String classpathScope;
    @Parameter(property="scopes")
    private List<String> scopes;
    @Parameter(property="includes")
    private List<String> includes;
    @Parameter(property="excludes")
    private List<String> excludes;
    @Parameter(property="transitiveIncludes")
    private List<String> transitiveIncludes;
    @Parameter(property="transitiveExcludes")
    private List<String> transitiveExcludes;
    @Parameter(property="targetIncludes")
    private List<String> targetIncludes;
    @Parameter(property="excludeOptionalDependencies", defaultValue="false")
    private boolean excludeOptionalDependencies;

    AbstractDependencyGraphMojo() {
    }

    @Override
    protected final GraphFactory createGraphFactory(GraphStyleConfigurer graphStyleConfigurer) {
        ArtifactFilter globalFilter = this.createGlobalArtifactFilter();
        ArtifactFilter transitiveIncludeExcludeFilter = this.createTransitiveIncludeExcludeFilter();
        ArtifactFilter targetFilter = this.createTargetArtifactFilter();
        return this.createGraphFactory(globalFilter, transitiveIncludeExcludeFilter, targetFilter, graphStyleConfigurer);
    }

    protected abstract GraphFactory createGraphFactory(ArtifactFilter var1, ArtifactFilter var2, ArtifactFilter var3, GraphStyleConfigurer var4);

    private ArtifactFilter createGlobalArtifactFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.scope != null) {
            this.getLog().warn((CharSequence)"The 'scope' parameter is deprecated and will be removed in future versions. Use 'classpathScope' instead.");
            if (this.classpathScope == null) {
                this.classpathScope = this.scope;
            }
        }
        if (this.classpathScope != null) {
            if (this.scopes.isEmpty()) {
                filter.add((ArtifactFilter)new ScopeArtifactFilter(this.classpathScope));
            } else {
                this.getLog().warn((CharSequence)"Both 'classpathScope' (formerly 'scope') and 'scopes' parameters are set. The 'classpathScope' parameter will be ignored.");
            }
        }
        if (!this.scopes.isEmpty()) {
            filter.add(this.createScopesArtifactFilter(this.scopes));
        }
        if (!this.includes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (!this.excludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        if (this.excludeOptionalDependencies) {
            filter.add((ArtifactFilter)new OptionalArtifactFilter());
        }
        return filter;
    }

    private ArtifactFilter createTransitiveIncludeExcludeFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.transitiveIncludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.transitiveIncludes));
        }
        if (!this.transitiveExcludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternExcludesArtifactFilter(this.transitiveExcludes));
        }
        return filter;
    }

    private ArtifactFilter createTargetArtifactFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.targetIncludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.targetIncludes));
        }
        return filter;
    }

    private ArtifactFilter createScopesArtifactFilter(List<String> scopes) {
        ScopeArtifactFilter filter = new ScopeArtifactFilter();
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                filter.setIncludeCompileScope(true);
                continue;
            }
            if ("runtime".equals(scope)) {
                filter.setIncludeRuntimeScope(true);
                continue;
            }
            if ("test".equals(scope)) {
                filter.setIncludeTestScope(true);
                continue;
            }
            if ("provided".equals(scope)) {
                filter.setIncludeProvidedScope(true);
                continue;
            }
            if ("system".equals(scope)) {
                filter.setIncludeSystemScope(true);
                continue;
            }
            this.getLog().warn((CharSequence)("Unknown scope: " + scope));
        }
        return filter;
    }

    private static class OptionalArtifactFilter
    implements ArtifactFilter {
        private OptionalArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            return !artifact.isOptional();
        }
    }
}

