/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultArchiveExtractor
implements ArchiveExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultArchiveExtractor.class);

    DefaultArchiveExtractor() {
    }

    private void prepDestination(File path, boolean directory) throws IOException {
        if (directory) {
            path.mkdirs();
        } else {
            if (!path.getParentFile().exists()) {
                path.getParentFile().mkdirs();
            }
            if (!path.getParentFile().canWrite()) {
                throw new AccessDeniedException(String.format("Could not get write permissions for '%s'", path.getParentFile().getAbsolutePath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extract(String archive, String destinationDirectory) throws ArchiveExtractionException {
        File archiveFile = new File(archive);
        try (FileInputStream fis = new FileInputStream(archiveFile);){
            if ("msi".equals(FileUtils.getExtension((String)archiveFile.getAbsolutePath()))) {
                String command = "msiexec /a " + archiveFile.getAbsolutePath() + " /qn TARGETDIR=\"" + destinationDirectory + "\"";
                Process child = Runtime.getRuntime().exec(command);
                try {
                    int result = child.waitFor();
                    if (result == 0) return;
                    throw new ArchiveExtractionException("Could not extract " + archiveFile.getAbsolutePath() + "; return code " + result);
                }
                catch (InterruptedException e) {
                    throw new ArchiveExtractionException("Unexpected interruption of while waiting for extraction process", e);
                }
            }
            if ("zip".equals(FileUtils.getExtension((String)archiveFile.getAbsolutePath()))) {
                try (ZipFile zipFile = new ZipFile(archiveFile);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        File destPath = new File(destinationDirectory + File.separator + entry.getName());
                        this.prepDestination(destPath, entry.isDirectory());
                        if (entry.isDirectory()) continue;
                        InputStream in = null;
                        FileOutputStream out = null;
                        try {
                            in = zipFile.getInputStream(entry);
                            out = new FileOutputStream(destPath);
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly((InputStream)in);
                            IOUtils.closeQuietly(out);
                            throw throwable;
                            return;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
            }
            TarArchiveInputStream tarIn = null;
            try {
                tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)fis));
                TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
                while (tarEntry != null) {
                    File destPath = new File(destinationDirectory + File.separator + tarEntry.getName());
                    this.prepDestination(destPath, tarEntry.isDirectory());
                    if (!tarEntry.isDirectory()) {
                        destPath.createNewFile();
                        boolean isExecutable = (tarEntry.getMode() & 0x40) > 0;
                        destPath.setExecutable(isExecutable);
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(destPath);
                            IOUtils.copy((InputStream)tarIn, (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                    tarEntry = tarIn.getNextTarEntry();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tarIn);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)tarIn);
            return;
        }
        catch (IOException e) {
            throw new ArchiveExtractionException("Could not extract archive: '" + archive + "'", e);
        }
    }
}

