/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.spectrum.impl;

import java.io.Serializable;
import umich.ms.datatypes.spectrum.AbstractSpectrum;

public class SpectrumDefault
extends AbstractSpectrum
implements Serializable {
    private static final long serialVersionUID = -2198926992332773666L;
    protected double[] mz;
    protected double[] intensity;
    protected double[] im;

    public SpectrumDefault(double[] mz, double[] intensity, double[] im, double intLo, double intLoNonZero, double basePeakIntensity, double basePeakMz, double intSum) {
        if (mz.length != intensity.length) {
            throw new IllegalArgumentException("M/z and Intensity arrays must be of equal length");
        }
        if (im != null && im.length > 0 && mz.length != im.length) {
            throw new IllegalArgumentException("M/z and Ion Mobility arrays must be of equal length");
        }
        this.mz = mz;
        this.intensity = intensity;
        this.im = im;
        if (mz.length > 0) {
            this.init(mz[0], mz[mz.length - 1], intLo, intLoNonZero, basePeakIntensity, basePeakMz, intSum);
        } else {
            this.init(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public SpectrumDefault(double[] mz, double[] intensity, double[] im) {
        if (mz.length != intensity.length) {
            throw new IllegalArgumentException("M/z and Intensity arrays must be of equal length");
        }
        if (im != null && mz.length != im.length) {
            throw new IllegalArgumentException("M/z and Ion Mobility arrays must be of equal length");
        }
        this.mz = mz;
        this.intensity = intensity;
        this.im = im;
        if (mz.length <= 0) {
            this.init(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            double intLo = Double.POSITIVE_INFINITY;
            double intLoNonZero = Double.POSITIVE_INFINITY;
            double intHi = Double.NEGATIVE_INFINITY;
            double intHiMz = Double.NEGATIVE_INFINITY;
            double intSum = 0.0;
            double mzLo = Double.POSITIVE_INFINITY;
            double mzHi = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < intensity.length; ++i) {
                if (intLo > intensity[i] && (intLo = intensity[i]) > 0.0) {
                    intLoNonZero = intLo;
                }
                if (intHi < intensity[i]) {
                    intHi = intensity[i];
                    intHiMz = mz[i];
                }
                if (mzLo > mz[i]) {
                    mzLo = mz[i];
                }
                if (mzHi < mz[i]) {
                    mzHi = mz[i];
                }
                intSum += intensity[i];
            }
            this.init(mzLo, mzHi, intLo, intLoNonZero, intHi, intHiMz, intSum);
        }
    }

    private void init(double mzLo, double mzHi, double intLo, double intLoNonZero, double intHi, double intHiMz, double intSum) {
        this.minMZ = mzLo;
        this.maxMZ = mzHi;
        this.minInt = intLo;
        this.minIntNonZero = intLoNonZero;
        this.maxInt = intHi;
        this.maxIntMz = intHiMz;
        this.sumInt = intSum;
    }

    @Override
    public double[] getMZs() {
        return this.mz;
    }

    @Override
    public double[] getIntensities() {
        return this.intensity;
    }

    @Override
    public double[] getIMs() {
        return this.im;
    }

    public void setIntensities(double[] intensity) {
        this.intensity = intensity;
    }

    public void setMzs(double[] mz) {
        this.mz = mz;
    }

    @Override
    public int[] findMzIdxs(double mzLo, double mzHi) {
        Integer mzLoIdx = this.findMzIdxCeiling(mzLo);
        Integer mzHiIdx = this.findMzIdxFloor(mzHi);
        if (mzLoIdx == null || mzHiIdx == null || mzLoIdx > mzHiIdx) {
            return null;
        }
        return new int[]{mzLoIdx, mzHiIdx};
    }
}

