
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzml.jaxb;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * A single chromatogram.
 *
 * <p>Java class for ChromatogramType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="ChromatogramType">
 *   &lt;complexContent>
 *     &lt;extension base="{http://psi.hupo.org/ms/mzml}ParamGroupType">
 *       &lt;sequence>
 *         &lt;element name="precursor" type="{http://psi.hupo.org/ms/mzml}PrecursorType" minOccurs="0"/>
 *         &lt;element name="product" type="{http://psi.hupo.org/ms/mzml}ProductType" minOccurs="0"/>
 *         &lt;element name="binaryDataArrayList" type="{http://psi.hupo.org/ms/mzml}BinaryDataArrayListType"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="index" use="required" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *       &lt;attribute name="defaultArrayLength" use="required" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="dataProcessingRef" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ChromatogramType", propOrder = {
    "precursor",
    "product",
    "binaryDataArrayList"
})
public class ChromatogramType
    extends ParamGroupType {

  protected PrecursorType precursor;
  protected ProductType product;
  @XmlElement(required = true)
  protected BinaryDataArrayListType binaryDataArrayList;
  @XmlAttribute(name = "id", required = true)
  protected String id;
  @XmlAttribute(name = "index", required = true)
  @XmlJavaTypeAdapter(Adapter1.class)
  @XmlSchemaType(name = "nonNegativeInteger")
  protected Integer index;
  @XmlAttribute(name = "defaultArrayLength", required = true)
  protected int defaultArrayLength;
  @XmlAttribute(name = "dataProcessingRef")
  @XmlIDREF
  @XmlSchemaType(name = "IDREF")
  protected Object dataProcessingRef;

  /**
   * Gets the value of the precursor property.
   *
   * @return possible object is {@link PrecursorType }
   */
  public PrecursorType getPrecursor() {
    return precursor;
  }

  /**
   * Sets the value of the precursor property.
   *
   * @param value allowed object is {@link PrecursorType }
   */
  public void setPrecursor(PrecursorType value) {
    this.precursor = value;
  }

  /**
   * Gets the value of the product property.
   *
   * @return possible object is {@link ProductType }
   */
  public ProductType getProduct() {
    return product;
  }

  /**
   * Sets the value of the product property.
   *
   * @param value allowed object is {@link ProductType }
   */
  public void setProduct(ProductType value) {
    this.product = value;
  }

  /**
   * Gets the value of the binaryDataArrayList property.
   *
   * @return possible object is {@link BinaryDataArrayListType }
   */
  public BinaryDataArrayListType getBinaryDataArrayList() {
    return binaryDataArrayList;
  }

  /**
   * Sets the value of the binaryDataArrayList property.
   *
   * @param value allowed object is {@link BinaryDataArrayListType }
   */
  public void setBinaryDataArrayList(BinaryDataArrayListType value) {
    this.binaryDataArrayList = value;
  }

  /**
   * Gets the value of the id property.
   *
   * @return possible object is {@link String }
   */
  public String getId() {
    return id;
  }

  /**
   * Sets the value of the id property.
   *
   * @param value allowed object is {@link String }
   */
  public void setId(String value) {
    this.id = value;
  }

  /**
   * Gets the value of the index property.
   *
   * @return possible object is {@link String }
   */
  public Integer getIndex() {
    return index;
  }

  /**
   * Sets the value of the index property.
   *
   * @param value allowed object is {@link String }
   */
  public void setIndex(Integer value) {
    this.index = value;
  }

  /**
   * Gets the value of the defaultArrayLength property.
   */
  public int getDefaultArrayLength() {
    return defaultArrayLength;
  }

  /**
   * Sets the value of the defaultArrayLength property.
   */
  public void setDefaultArrayLength(int value) {
    this.defaultArrayLength = value;
  }

  /**
   * Gets the value of the dataProcessingRef property.
   *
   * @return possible object is {@link Object }
   */
  public Object getDataProcessingRef() {
    return dataProcessingRef;
  }

  /**
   * Sets the value of the dataProcessingRef property.
   *
   * @param value allowed object is {@link Object }
   */
  public void setDataProcessingRef(Object value) {
    this.dataProcessingRef = value;
  }

}
